/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.redis.sequence.impls;

import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.sequence.ISequenceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import org.springframework.lang.NonNull;

@LoadLevel(name="redisSequenceService", order=100)
public class SpringRedisSequenceServiceImpl
implements ISequenceService {
    private static RedisConnectionFactory connectionFactory;

    public long nextVal(@NonNull String seqName) {
        return this.getAtomicLong(seqName).incrementAndGet();
    }

    public long currVal(@NonNull String seqName) {
        return this.getAtomicLong(seqName).get();
    }

    public long setVal(@NonNull String seqName, long newVal) {
        this.getAtomicLong(seqName).set(newVal);
        return -1L;
    }

    private RedisAtomicLong getAtomicLong(String seqName) {
        return new RedisAtomicLong(seqName, connectionFactory);
    }

    @Autowired
    public void setConnectionFactory(RedisConnectionFactory connectionFactory) {
        SpringRedisSequenceServiceImpl.connectionFactory = connectionFactory;
    }
}

