/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.sdk.s3.dwz;

import cn.hutool.core.lang.Assert;
import cn.hutool.json.JSONUtil;
import icu.easyj.core.util.UrlUtils;
import icu.easyj.sdk.dwz.DwzRequest;
import icu.easyj.sdk.dwz.DwzResponse;
import icu.easyj.sdk.dwz.DwzSdkException;
import icu.easyj.sdk.dwz.IDwzTemplate;
import icu.easyj.sdk.s3.dwz.S3DwzConfig;
import icu.easyj.sdk.s3.dwz.S3DwzErrorType;
import icu.easyj.sdk.s3.dwz.S3DwzResponse;
import icu.easyj.sdk.s3.dwz.S3DwzResponseData;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;

public class S3DwzTemplateImpl
implements IDwzTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3DwzTemplateImpl.class);
    private final S3DwzConfig config;
    private final RestTemplate restTemplate;

    public S3DwzTemplateImpl(S3DwzConfig config) {
        Assert.notNull((Object)config, (String)"'config' must be not null", (Object[])new Object[0]);
        this.config = config;
        this.restTemplate = new RestTemplate();
        ((DefaultUriBuilderFactory)this.restTemplate.getUriTemplateHandler()).setEncodingMode(DefaultUriBuilderFactory.EncodingMode.NONE);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DwzResponse createShortUrl(DwzRequest request) throws DwzSdkException {
        DwzResponse dwzResponse;
        Throwable t;
        String respStr;
        String url;
        long startTime;
        block9: {
            Assert.notNull((Object)request, (String)"'request' must be not null", (Object[])new Object[0]);
            Assert.notNull((Object)request.getLongUrl(), (String)"'longUrl' must be not null", (Object[])new Object[0]);
            startTime = System.nanoTime();
            url = null;
            respStr = null;
            t = null;
            try {
                url = this.config.getServiceUrl() + "?client_id=" + this.config.getClientId() + "&client_secret=" + this.config.getClientSecret() + "&url=" + UrlUtils.encode((String)request.getLongUrl());
                respStr = (String)this.restTemplate.getForObject(url, String.class, new Object[0]);
                if (respStr == null) {
                    throw new DwzSdkException("\u8bf7\u6c42S-3\u77ed\u94fe\u63a5\u670d\u52a1\u65e0\u54cd\u5e94", "NO_RESPONSE");
                }
                S3DwzResponse resp = (S3DwzResponse)JSONUtil.toBean((String)respStr, S3DwzResponse.class);
                if (!resp.isSuccess()) {
                    S3DwzErrorType errorType = resp.getErrorType();
                    String errorMsg = resp.getErrorMessage(errorType);
                    String errorCode = errorType != null ? errorType.name() : resp.getCode();
                    throw new DwzSdkException("\u8bf7\u6c42S-3\u77ed\u94fe\u63a5\u670d\u52a1\u5931\u8d25\uff1a[" + resp.getCode() + "]" + errorMsg, errorCode);
                }
                if (resp.getData() == null) {
                    throw new DwzSdkException("\u8bf7\u6c42S-3\u77ed\u94fe\u63a5\u670d\u52a1\u7684\u54cd\u5e94\u4e2d\u65e0\u6570\u636e", "NO_DATA");
                }
                dwzResponse = this.convertToStandard(resp);
                if (t != null) break block9;
            }
            catch (DwzSdkException e) {
                try {
                    t = e;
                    throw e;
                    catch (RuntimeException e2) {
                        t = e2;
                        throw new DwzSdkException("S-3\u77ed\u94fe\u63a5\u670d\u52a1\u672a\u77e5\u5f02\u5e38", (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (t == null) {
                        if (!LOGGER.isInfoEnabled()) throw throwable;
                        LOGGER.info("S-3\u77ed\u94fe\u63a5\u670d\u52a1\u8c03\u7528\u6210\u529f\uff1a\r\n -  url: {}\r\n - resp: {}\r\n - cost: {} ms", new Object[]{url, respStr, Float.valueOf((float)(System.nanoTime() - startTime) / 1000000.0f)});
                        throw throwable;
                    }
                    if (!LOGGER.isErrorEnabled()) throw throwable;
                    LOGGER.error("S-3\u77ed\u94fe\u63a5\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff1a{}\r\n -  url: {}\r\n - resp: {}\r\n - cost: {} ms", new Object[]{t.getMessage(), url, respStr, Float.valueOf((float)(System.nanoTime() - startTime) / 1000000.0f)});
                    throw throwable;
                }
            }
            if (!LOGGER.isInfoEnabled()) return dwzResponse;
            LOGGER.info("S-3\u77ed\u94fe\u63a5\u670d\u52a1\u8c03\u7528\u6210\u529f\uff1a\r\n -  url: {}\r\n - resp: {}\r\n - cost: {} ms", new Object[]{url, respStr, Float.valueOf((float)(System.nanoTime() - startTime) / 1000000.0f)});
            return dwzResponse;
        }
        if (!LOGGER.isErrorEnabled()) return dwzResponse;
        LOGGER.error("S-3\u77ed\u94fe\u63a5\u670d\u52a1\u8c03\u7528\u5931\u8d25\uff1a{}\r\n -  url: {}\r\n - resp: {}\r\n - cost: {} ms", new Object[]{t.getMessage(), url, respStr, Float.valueOf((float)(System.nanoTime() - startTime) / 1000000.0f)});
        return dwzResponse;
    }

    private DwzResponse convertToStandard(S3DwzResponse resp) {
        DwzResponse response = new DwzResponse();
        S3DwzResponseData data = resp.getData();
        response.setShortUrl(data.getUrlShort());
        if (data.getCreateTime() != null) {
            response.setCreateTime(new Date(data.getCreateTime() * 1000L));
        } else {
            response.setCreateTime(new Date());
        }
        response.setExpireIn(Long.valueOf(data.getExpireIn() != null ? data.getExpireIn() : 0L));
        return response;
    }
}

