/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.sdk.tencent.cloud.ocr.idcardocr.impls;

import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.common.profile.Language;
import com.tencentcloudapi.ocr.v20181119.OcrClient;
import com.tencentcloudapi.ocr.v20181119.models.IDCardOCRRequest;
import com.tencentcloudapi.ocr.v20181119.models.IDCardOCRResponse;
import icu.easyj.core.util.StringUtils;
import icu.easyj.sdk.tencent.cloud.ocr.idcardocr.ITencentCloudIdCardOcrTemplate;
import icu.easyj.sdk.tencent.cloud.ocr.idcardocr.TencentCloudIdCardOcrConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultTencentCloudIdCardOcrTemplate
implements ITencentCloudIdCardOcrTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTencentCloudIdCardOcrTemplate.class);
    private static final String ENDPOINT = "ocr.tencentcloudapi.com";
    @Nullable
    private final TencentCloudIdCardOcrConfig globalConfig;
    @Nullable
    private final OcrClient globalClient;

    public DefaultTencentCloudIdCardOcrTemplate() {
        this.globalConfig = null;
        this.globalClient = null;
    }

    public DefaultTencentCloudIdCardOcrTemplate(@NonNull TencentCloudIdCardOcrConfig globalConfig) {
        Assert.notNull((Object)((Object)globalConfig), (String)"'globalConfig' must be not null");
        this.globalConfig = globalConfig;
        this.globalClient = this.newOcrClient(globalConfig);
    }

    @Override
    public IDCardOCRResponse doIdCardOcr(IDCardOCRRequest request, @Nullable TencentCloudIdCardOcrConfig config) throws TencentCloudSDKException {
        if (config == null) {
            Assert.notNull((Object)((Object)this.globalConfig), (String)"'this.globalConfig' must be not null");
            config = this.globalConfig;
        }
        this.mergeGlobalConfig(config);
        Assert.notNull((Object)config.getSecretId(), (String)"'secretId' must be not null");
        Assert.notNull((Object)config.getSecretKey(), (String)"'secretKey' must be not null");
        Assert.notNull((Object)config.getRegion(), (String)"'region' must be not null");
        long startTime = System.nanoTime();
        try {
            OcrClient client;
            if (config == this.globalConfig) {
                Assert.notNull((Object)this.globalClient, (String)"\u672a\u8bbe\u7f6e\u5168\u5c40\u914d\u7f6e\uff0c\u6ca1\u6709\u751f\u6210\u8fc7\u5168\u5c40\u5ba2\u6237\u7aef\u5b9e\u4f8b\u3002");
                client = this.globalClient;
            } else {
                client = this.newOcrClient(config);
            }
            IDCardOCRResponse response = client.IDCardOCR(request);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("IDCardOCR \u8bf7\u6c42\u6210\u529f\uff01\r\n Request: {}\r\nResponse: {}\r\n  Config: {}\r\n   Cost: {} ms", new Object[]{StringUtils.toString((Object)request), StringUtils.toString((Object)response), StringUtils.toString((Object)((Object)config)), (System.nanoTime() - startTime) / 1000000L});
            }
            return response;
        }
        catch (TencentCloudSDKException | RuntimeException e) {
            LOGGER.error("IDCardOCR \u8bf7\u6c42\u5931\u8d25\uff1a{}\r\nRequest: {}\r\n Config: {}\r\n  Cost: {} ms", new Object[]{e, StringUtils.toString((Object)request), StringUtils.toString((Object)((Object)config)), (System.nanoTime() - startTime) / 1000000L});
            if (e instanceof TencentCloudSDKException) {
                throw (TencentCloudSDKException)e;
            }
            throw new RuntimeException("IDCardOCR \u8bf7\u6c42\u5931\u8d25", e);
        }
    }

    private void mergeGlobalConfig(@NonNull TencentCloudIdCardOcrConfig config) {
        if (config != this.globalConfig && this.globalConfig != null) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)config.getSecretId())) {
                config.setSecretId(this.globalConfig.getSecretId());
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)config.getSecretKey())) {
                config.setSecretKey(this.globalConfig.getSecretKey());
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)config.getRegion())) {
                config.setRegion(this.globalConfig.getRegion());
            }
            if (config.getConnTimeout() == null) {
                config.setConnTimeout(this.globalConfig.getConnTimeout());
            }
            if (config.getWriteTimeout() == null) {
                config.setWriteTimeout(this.globalConfig.getWriteTimeout());
            }
            if (config.getReadTimeout() == null) {
                config.setReadTimeout(this.globalConfig.getReadTimeout());
            }
            if (config.getLanguage() == null) {
                config.setLanguage(this.globalConfig.getLanguage());
            }
            if (config.getDebug() == null) {
                config.setDebug(this.globalConfig.getDebug());
            }
        }
    }

    @Nullable
    private Credential newCredential(TencentCloudIdCardOcrConfig config) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)config.getSecretId()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)config.getSecretKey())) {
            return new Credential(config.getSecretId(), config.getSecretKey());
        }
        return null;
    }

    @NonNull
    private HttpProfile newHttpProfile(TencentCloudIdCardOcrConfig config) {
        HttpProfile httpProfile = new HttpProfile();
        httpProfile.setEndpoint(ENDPOINT);
        if (config.getConnTimeout() != null && config.getConnTimeout() > 0) {
            httpProfile.setConnTimeout(config.getConnTimeout().intValue());
        }
        if (config.getWriteTimeout() != null && config.getWriteTimeout() > 0) {
            httpProfile.setWriteTimeout(config.getWriteTimeout().intValue());
        }
        if (config.getReadTimeout() != null && config.getReadTimeout() > 0) {
            httpProfile.setReadTimeout(config.getReadTimeout().intValue());
        }
        return httpProfile;
    }

    private ClientProfile newClientProfile(HttpProfile httpProfile, TencentCloudIdCardOcrConfig config) {
        ClientProfile clientProfile = new ClientProfile();
        clientProfile.setHttpProfile(httpProfile);
        clientProfile.setLanguage(config.getLanguage() == null ? Language.ZH_CN : config.getLanguage());
        clientProfile.setDebug(config.getDebug() != null && config.getDebug() != false);
        return clientProfile;
    }

    private OcrClient newOcrClient(TencentCloudIdCardOcrConfig config) {
        Credential cred = this.newCredential(config);
        HttpProfile httpProfile = this.newHttpProfile(config);
        ClientProfile clientProfile = this.newClientProfile(httpProfile, config);
        return new OcrClient(cred, config.getRegion(), clientProfile);
    }

    @Nullable
    public TencentCloudIdCardOcrConfig getGlobalConfig() {
        return this.globalConfig;
    }
}

