/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.sdk.tencent.cloud.ocr.idcardocr.impls;

import cn.hutool.core.lang.Assert;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.ocr.v20181119.models.IDCardOCRRequest;
import com.tencentcloudapi.ocr.v20181119.models.IDCardOCRResponse;
import icu.easyj.core.util.CollectionUtils;
import icu.easyj.core.util.DateUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.sdk.ocr.CardSide;
import icu.easyj.sdk.ocr.idcardocr.IIdCardOcrTemplate;
import icu.easyj.sdk.ocr.idcardocr.IdCardOcrAdvanced;
import icu.easyj.sdk.ocr.idcardocr.IdCardOcrRequest;
import icu.easyj.sdk.ocr.idcardocr.IdCardOcrResponse;
import icu.easyj.sdk.ocr.idcardocr.IdCardOcrSdkClientException;
import icu.easyj.sdk.ocr.idcardocr.IdCardOcrSdkException;
import icu.easyj.sdk.ocr.idcardocr.IdCardOcrSdkServerException;
import icu.easyj.sdk.ocr.idcardocr.IdCardOcrWarn;
import icu.easyj.sdk.tencent.cloud.ocr.OcrRequestBuilder;
import icu.easyj.sdk.tencent.cloud.ocr.idcardocr.ITencentCloudIdCardOcrTemplate;
import icu.easyj.sdk.tencent.cloud.ocr.idcardocr.IdCardOcrAdvancedInfo;
import icu.easyj.sdk.tencent.cloud.ocr.idcardocr.IdCardOcrRequestBuilder;
import icu.easyj.sdk.tencent.cloud.ocr.idcardocr.TencentCloudIdCardOcrConfig;
import icu.easyj.sdk.tencent.cloud.ocr.idcardocr.TencentIdCardOcrWarn;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class TencentEasyjIdCardOcrTemplateImpl
implements IIdCardOcrTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(TencentEasyjIdCardOcrTemplateImpl.class);
    public static final int MIN_QUALITY = 50;
    private final ITencentCloudIdCardOcrTemplate tencentCloudIdCardOcrTemplate;

    public TencentEasyjIdCardOcrTemplateImpl(ITencentCloudIdCardOcrTemplate tencentCloudIdCardOcrTemplate) {
        Assert.notNull((Object)tencentCloudIdCardOcrTemplate, (String)"'tencentCloudIdCardOcrTemplate' must not be null", (Object[])new Object[0]);
        this.tencentCloudIdCardOcrTemplate = tencentCloudIdCardOcrTemplate;
    }

    @NonNull
    public IdCardOcrResponse idCardOcr(@NonNull IdCardOcrRequest request) throws IdCardOcrSdkException {
        IDCardOCRResponse resp;
        Assert.notNull((Object)request, (String)"'request' must not be null", (Object[])new Object[0]);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)request.getImage()), (String)"'image' must not be null", (Object[])new Object[0]);
        String image = request.getImage();
        CardSide cardSide = request.getCardSide();
        Integer minQuality = request.getMinQuality();
        IdCardOcrAdvanced[] advancedArr = request.getAdvancedArr();
        Map config = request.getConfig();
        if (CardSide.BOTH == cardSide) {
            cardSide = null;
        }
        IdCardOcrRequestBuilder builder = OcrRequestBuilder.idCardOcrRequestBuilder().image(image).cardSide(cardSide);
        this.setAdvanced(builder, advancedArr);
        IDCardOCRRequest req = builder.build();
        try {
            TencentCloudIdCardOcrConfig tencentCloudIdCardOcrConfig = TencentCloudIdCardOcrConfig.fromMap(config);
            resp = this.tencentCloudIdCardOcrTemplate.doIdCardOcr(req, tencentCloudIdCardOcrConfig);
        }
        catch (TencentCloudSDKException e) {
            String errorCode = e.getErrorCode();
            String errorMsg = "\u8eab\u4efd\u8bc1\u8bc6\u522b\u5931\u8d25" + (StringUtils.isNotEmpty((CharSequence)errorCode) ? "\uff1a" + errorCode : "");
            throw new IdCardOcrSdkServerException(errorMsg, errorCode, (Throwable)e);
        }
        catch (IdCardOcrSdkException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IdCardOcrSdkClientException("\u8eab\u4efd\u8bc1\u8bc6\u522b\u51fa\u73b0\u672a\u77e5\u5f02\u5e38", "UNKNOWN_ERROR", (Throwable)e);
        }
        IdCardOcrResponse response = new IdCardOcrResponse();
        if (StringUtils.isNotBlank((CharSequence)resp.getName())) {
            response.setCardSide(CardSide.FRONT);
        } else if (StringUtils.isNotBlank((CharSequence)resp.getAuthority())) {
            response.setCardSide(CardSide.BACK);
        } else {
            throw new IdCardOcrSdkServerException("\u672a\u77e5\u7684\u8eab\u4efd\u8bc1\u6b63\u53cd\u9762\u4fe1\u606f", "UNKNOWN_CARD_SIDE");
        }
        if (cardSide != null && cardSide != response.getCardSide()) {
            throw new IdCardOcrSdkServerException("\u5f53\u524d\u8eab\u4efd\u8bc1\u56fe\u7247\u4e0d\u662f" + cardSide.sideName() + "\u7167", "WRONG_CARD_SIDE");
        }
        if (CardSide.FRONT == response.getCardSide()) {
            response.setName(resp.getName());
            response.setSex(resp.getSex());
            response.setNation(resp.getNation());
            this.setBirthday(response, resp.getBirth());
            response.setAddress(resp.getAddress());
            response.setIdNum(resp.getIdNum());
        }
        if (CardSide.BACK == response.getCardSide()) {
            response.setAuthority(resp.getAuthority());
            this.setValidDate(response, resp.getValidDate());
        }
        this.setResponseAdvancedInfo(response, resp.getAdvancedInfo(), minQuality);
        return response;
    }

    private void setAdvanced(IdCardOcrRequestBuilder builder, IdCardOcrAdvanced[] advancedArr) {
        builder.enableMultiCardDetect();
        if (ArrayUtils.isNotEmpty((Object[])advancedArr)) {
            block10: for (IdCardOcrAdvanced advanced : advancedArr) {
                if (advanced == null) continue;
                switch (advanced) {
                    case CROP_ID_CARD: {
                        builder.enableCropIdCard();
                        continue block10;
                    }
                    case CROP_PORTRAIT: {
                        builder.enableCropPortrait();
                        continue block10;
                    }
                    case DETECT_INVALID: {
                        builder.enableInvalidDateWarn();
                        continue block10;
                    }
                    case DETECT_INCOMPLETE: {
                        builder.enableBorderCheckWarn();
                        continue block10;
                    }
                    case DETECT_DEFINITION: {
                        builder.enableQuality().enableReflectWarn();
                        continue block10;
                    }
                    case DETECT_COPY: {
                        builder.enableCopyWarn().enableReshootWarn();
                        continue block10;
                    }
                    case DETECT_TEMP: {
                        builder.enableTempIdWarn();
                        continue block10;
                    }
                    case DETECT_FAKE: {
                        builder.enableDetectPsWarn();
                        continue block10;
                    }
                    default: {
                        if (!LOGGER.isWarnEnabled()) continue block10;
                        LOGGER.warn("\u672a\u77e5\u7684`IdCardOCR`\u9ad8\u7ea7\u529f\u80fd\uff1a{}", (Object)advanced.name());
                    }
                }
            }
        }
    }

    private void setBirthday(IdCardOcrResponse response, String birthday) throws IdCardOcrSdkException {
        try {
            response.setBirthday(DateUtils.parseDate2((String)birthday));
        }
        catch (ParseException e) {
            throw new IdCardOcrSdkException("\u51fa\u751f\u65e5\u671f\u89e3\u6790\u5931\u8d25\uff1a" + birthday, "PARSE_BIRTHDAY_FAILED", (Throwable)e);
        }
    }

    private void setValidDate(IdCardOcrResponse response, String validDate) throws IdCardOcrSdkException {
        String[] validDateArr = validDate.split("-");
        try {
            String validDateStartStr = validDateArr[0];
            String validDateEndStr = validDateArr[1];
            Date validDateStart = DateUtils.parseDate3((String)validDateStartStr);
            Date validDateEnd = "\u957f\u671f".equals(validDateEndStr) ? null : DateUtils.parseDate3((String)validDateEndStr);
            response.setValidDateStart(validDateStart);
            response.setValidDateEnd(validDateEnd);
        }
        catch (Exception e) {
            throw new IdCardOcrSdkException("\u8eab\u4efd\u8bc1\u6709\u6548\u671f\u9650\u89e3\u6790\u5931\u8d25\uff1a" + validDate, "PARSE_VALID_DATE_FAILED", (Throwable)e);
        }
    }

    private void setResponseAdvancedInfo(IdCardOcrResponse response, String advancedInfoJson, Integer minQuality) {
        IdCardOcrAdvancedInfo advancedInfo = IdCardOcrAdvancedInfo.fromJsonString(advancedInfoJson);
        if (advancedInfo == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)advancedInfo.getIdCardBase64())) {
            response.setIdCardBase64(advancedInfo.getIdCardBase64());
        }
        if (StringUtils.isNotBlank((CharSequence)advancedInfo.getPortraitBase64())) {
            response.setPortraitBase64(advancedInfo.getPortraitBase64());
        }
        if (!CollectionUtils.isEmpty(advancedInfo.getWarnInfos())) {
            for (Integer warnCode : advancedInfo.getWarnInfos()) {
                TencentIdCardOcrWarn warn = TencentIdCardOcrWarn.get(warnCode);
                if (warn != null) {
                    response.addWarns(IdCardOcrWarn.get((String)warn.name()));
                    continue;
                }
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("\u8eab\u4efd\u8bc1\u8bc6\u522b\u63a5\u53e3\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u544a\u8b66\u7801\uff1a{}", (Object)warnCode);
            }
        }
        if (advancedInfo.getQuality() != null && advancedInfo.getQuality() < this.getMinQuality(minQuality)) {
            response.getWarns().add(IdCardOcrWarn.VAGUE);
        }
    }

    private int getMinQuality(Integer minQuality) {
        if (minQuality == null) {
            TencentCloudIdCardOcrConfig globalConfig = this.tencentCloudIdCardOcrTemplate.getGlobalConfig();
            Integer n = minQuality = globalConfig == null ? null : globalConfig.getMinQuality();
            if (minQuality == null || minQuality <= 0 || minQuality >= 100) {
                minQuality = 50;
            }
        }
        return minQuality;
    }
}

