/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.test.util;

import icu.easyj.test.util.InnerStringUtils;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class TestUtils {
    private static long executeOnePerformanceTest(int threadCount, int times, Supplier<?> supplier) {
        long startTime = TestUtils.getStartTime();
        String supplierName = supplier.get().toString();
        Thread currentThread = Thread.currentThread();
        if (threadCount > 1) {
            AtomicInteger atomicInteger = new AtomicInteger(threadCount);
            Thread[] threads = new Thread[threadCount];
            for (int i = 0; i < threadCount; ++i) {
                threads[i] = new Thread(() -> {
                    for (int j = 0; j < times; ++j) {
                        supplier.get();
                    }
                    if (atomicInteger.decrementAndGet() == 0) {
                        currentThread.resume();
                    }
                });
            }
            for (Thread thread : threads) {
                thread.start();
            }
        } else {
            for (int i = 0; i < times; ++i) {
                supplier.get();
            }
        }
        if (threadCount > 1) {
            currentThread.suspend();
        }
        long cost = TestUtils.getCost(startTime);
        String costStr = String.valueOf(cost);
        System.out.println("| \u51fd\u6570\u540d\uff1a" + StringUtils.rightPad((String)supplierName, (int)(16 + supplierName.length() - InnerStringUtils.chineseLength(supplierName)), (char)' ') + "\u8017\u65f6\uff1a" + StringUtils.leftPad((String)costStr, (int)7, (char)' ') + " ms          |");
        return cost;
    }

    @NonNull
    public static long[] performanceTest(int threadCount, int times, Supplier<?> ... suppliers) {
        Assert.isTrue((threadCount > 0 ? 1 : 0) != 0, (String)"'sets' must be greater than 0");
        Assert.isTrue((times > 0 ? 1 : 0) != 0, (String)"'times' must be greater than 0");
        Assert.isTrue((suppliers != null && suppliers.length > 0 ? 1 : 0) != 0, (String)"'suppliers' must be not empty");
        System.out.println("\r\n\u6027\u80fd\u6d4b\u8bd5\u9884\u70ed\u4e2d...");
        long startTime = TestUtils.getStartTime();
        for (Supplier<?> supplier : suppliers) {
            long startTime1 = TestUtils.getStartTime();
            int i = times;
            while (i-- > 0) {
                supplier.get();
            }
            System.out.println(TestUtils.getCost(startTime1));
        }
        System.out.println("\u6027\u80fd\u6d4b\u8bd5\u9884\u70ed\u5b8c\u6210: " + TestUtils.getCost(startTime) + " ms\r\n");
        System.out.println("--------------------------------------------------");
        System.out.println("| \u5f00\u59cb\u6027\u80fd\u6d4b\u8bd5\uff1a" + StringUtils.rightPad((String)(threadCount + " * " + times), (int)36, (char)' ') + "|");
        System.out.println("--------------------------------------------------");
        long[] costs = new long[suppliers.length];
        for (int y = 0; y < suppliers.length; ++y) {
            int n = y;
            costs[n] = costs[n] + TestUtils.executeOnePerformanceTest(threadCount, times, suppliers[y]);
        }
        System.out.println("--------------------------------------------------");
        return costs;
    }

    public static long getStartTime() {
        return System.nanoTime();
    }

    public static long getCost(long startNanoTime) {
        return (System.nanoTime() - startNanoTime) / 1000000L;
    }
}

