/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.test.util;

import icu.easyj.test.exception.TestException;
import icu.easyj.test.util.InnerStringUtils;
import icu.easyj.test.util.TestParam;
import java.util.concurrent.CountDownLatch;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class TestUtils {
    private static long executeOnePerformanceTest(int threadCount, int times, Function<TestParam, ?> function) {
        long startTime = TestUtils.getStartTime();
        String supplierName = function.apply(new TestParam(0, 0, true)).toString();
        if (threadCount > 1) {
            CountDownLatch countDownLatch = new CountDownLatch(threadCount);
            Thread[] threads = new Thread[threadCount];
            for (int i = 0; i < threadCount; ++i) {
                int threadNo = i + 1;
                threads[i] = new Thread(() -> {
                    TestParam param = new TestParam(threadNo, 0, false);
                    for (int j = 1; j <= times; ++j) {
                        function.apply(param.setRunNo(j));
                    }
                    countDownLatch.countDown();
                });
                threads[i].setName("TestThread_" + (i + 1));
            }
            for (Thread thread : threads) {
                thread.start();
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                throw new TestException("\u6d4b\u8bd5\u7ebf\u7a0b\u88ab\u4e2d\u65ad", e);
            }
        } else {
            TestParam param = new TestParam(1, 0, false);
            for (int i = 1; i <= times; ++i) {
                function.apply(param.setRunNo(i));
            }
        }
        long endTime = System.nanoTime();
        long cost = (endTime - startTime) / 1000000L;
        String costStr = String.valueOf(cost);
        long onceCost = (System.nanoTime() - startTime) / (long)times;
        String onceCostStr = onceCost + " ns";
        System.out.println("| \u51fd\u6570\u540d\uff1a" + StringUtils.rightPad((String)supplierName, (int)(16 + (supplierName.length() - InnerStringUtils.chineseLength(supplierName)) / 2)) + "\u8017\u65f6\uff1a" + StringUtils.leftPad((String)costStr, (int)7) + " ms         \u5355\u6b21\uff1a" + StringUtils.leftPad((String)onceCostStr, (int)13) + " |");
        return cost;
    }

    @NonNull
    public static long[] performanceTest(int threadCount, int times, Function<TestParam, ?> ... functions) {
        Assert.isTrue((threadCount > 0 ? 1 : 0) != 0, (String)"'sets' must be greater than 0");
        Assert.isTrue((times > 0 ? 1 : 0) != 0, (String)"'times' must be greater than 0");
        Assert.isTrue((functions != null && functions.length > 0 ? 1 : 0) != 0, (String)"'functions' must be not empty");
        System.out.println("\r\n\u6027\u80fd\u6d4b\u8bd5\u9884\u70ed\u4e2d...");
        long startTime = TestUtils.getStartTime();
        for (Function<TestParam, ?> function : functions) {
            long startTime1 = TestUtils.getStartTime();
            TestParam param = new TestParam(0, 0, true);
            for (int i = 1; i <= times; ++i) {
                function.apply(param.setRunNo(i));
            }
            System.out.println(TestUtils.getCost(startTime1));
        }
        System.out.println("\u6027\u80fd\u6d4b\u8bd5\u9884\u70ed\u5b8c\u6210: " + TestUtils.getCost(startTime) + " ms\r\n");
        System.out.println("--------------------------------------------------------------------");
        System.out.println("| \u5f00\u59cb\u6027\u80fd\u6d4b\u8bd5\uff1a" + StringUtils.rightPad((String)(threadCount + " * " + times), (int)54) + "|");
        System.out.println("--------------------------------------------------------------------");
        long[] costs = new long[functions.length];
        for (int y = 0; y < functions.length; ++y) {
            int n = y;
            costs[n] = costs[n] + TestUtils.executeOnePerformanceTest(threadCount, times, functions[y]);
        }
        System.out.println("--------------------------------------------------------------------");
        return costs;
    }

    @NonNull
    public static long[] performanceTest(int threadCount, int times, Supplier<?> ... suppliers) {
        Assert.isTrue((suppliers != null && suppliers.length > 0 ? 1 : 0) != 0, (String)"'suppliers' must be not empty");
        Function[] functions = new Function[suppliers.length];
        for (int i = 0; i < suppliers.length; ++i) {
            int n = i;
            functions[i] = t -> suppliers[n].get();
        }
        return TestUtils.performanceTest(threadCount, times, functions);
    }

    public static long getStartTime() {
        return System.nanoTime();
    }

    public static long getCost(long startNanoTime) {
        return (System.nanoTime() - startNanoTime) / 1000000L;
    }
}

