/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.cache304;

import icu.easyj.core.util.DateUtils;
import icu.easyj.web.cache304.CacheTimeComputer;
import icu.easyj.web.cache304.config.Cache304Config;
import icu.easyj.web.cache304.config.Cache304ConfigStorageFactory;
import icu.easyj.web.util.HttpUtils;
import java.util.Date;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public abstract class Cache304Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Cache304Utils.class);

    @Nullable
    public static Object doCache(HttpServletRequest request, HttpServletResponse response, Cache304Config config, Supplier<Object> callback) {
        Date lastModified;
        if (config == null) {
            return callback.get();
        }
        if (HttpUtils.isNoCacheRequest((HttpServletRequest)request)) {
            return Cache304Utils.doCallbackAndSetCache304Header(callback, response, config, -1L);
        }
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        if (StringUtils.isEmpty((Object)ifModifiedSince)) {
            return Cache304Utils.doCallbackAndSetCache304Header(callback, response, config, -1L);
        }
        try {
            lastModified = DateUtils.parseAll((String)ifModifiedSince);
        }
        catch (Exception ex) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u89e3\u6790\u65f6\u95f4\u5b57\u7b26\u4e32\u5931\u8d25\uff0cheader[\"{}\"] = {}, error = {}", new Object[]{"If-Modified-Since", ifModifiedSince, ex.getMessage()});
            }
            return Cache304Utils.doCallbackAndSetCache304Header(callback, response, config, -1L);
        }
        long passedTime = System.currentTimeMillis() - lastModified.getTime();
        long cacheTime = CacheTimeComputer.computeTime(lastModified, config);
        if (passedTime < cacheTime) {
            HttpUtils.setResponseStatus304((HttpServletResponse)response);
            return null;
        }
        return Cache304Utils.doCallbackAndSetCache304Header(callback, response, config, cacheTime);
    }

    public static Object doCache(HttpServletRequest request, HttpServletResponse response, Supplier<Object> callback) {
        Cache304Config config = Cache304ConfigStorageFactory.getStorage().getConfig(request);
        return Cache304Utils.doCache(request, response, config, callback);
    }

    public static void doCache(HttpServletRequest request, HttpServletResponse response, Cache304Config config, Runnable runnable) {
        Cache304Utils.doCache(request, response, config, () -> {
            runnable.run();
            return null;
        });
    }

    public static void doCache(HttpServletRequest request, HttpServletResponse response, Runnable runnable) {
        Cache304Config config = Cache304ConfigStorageFactory.getStorage().getConfig(request);
        Cache304Utils.doCache(request, response, config, runnable);
    }

    private static Object doCallbackAndSetCache304Header(Supplier<Object> callback, HttpServletResponse response, Cache304Config config, long cacheTime) {
        long runSeconds;
        long cacheSeconds = cacheTime > 0L ? cacheTime / 1000L : CacheTimeComputer.computeTime(new Date(), config) / 1000L;
        long startTime = System.nanoTime();
        Object result = callback.get();
        if (config.getCacheDays() > 0 && (runSeconds = (System.nanoTime() - startTime) / 1000000000L) > 0L && (cacheSeconds -= runSeconds) <= 0L) {
            return result;
        }
        Date now = new Date();
        response.addDateHeader("Last-Modified", now.getTime());
        if (config.isUseMaxAge()) {
            if (config.getLimitMaxAge() > 0L && cacheSeconds > config.getLimitMaxAge()) {
                cacheSeconds = config.getLimitMaxAge();
            }
            response.setDateHeader("Expires", new Date(now.getTime() + cacheSeconds * 1000L).getTime());
            response.addHeader("Cache-Control", "max-age=" + ++cacheSeconds);
        }
        return result;
    }
}

