/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.cache304.config;

import icu.easyj.core.util.UrlUtils;
import icu.easyj.web.cache304.config.Cache304Config;
import icu.easyj.web.cache304.config.ICache304ConfigStore;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;

public class DefaultCache304ConfigStoreImpl
implements ICache304ConfigStore {
    private final Map<String, Cache304Config> cache304ConfigMap;

    public DefaultCache304ConfigStoreImpl() {
        this.cache304ConfigMap = new ConcurrentHashMap<String, Cache304Config>(4);
    }

    public DefaultCache304ConfigStoreImpl(Map<String, Cache304Config> cache304ConfigMap) {
        this.cache304ConfigMap = cache304ConfigMap;
    }

    @Override
    public void putConfig(String path, Cache304Config config) {
        Assert.notNull((Object)path, (String)"'path' must be not null");
        Assert.notNull((Object)config, (String)"'config' must be not null");
        path = UrlUtils.normalizePath((String)path);
        this.cache304ConfigMap.put(path, config);
    }

    @Override
    public Cache304Config getConfig(String path) {
        Assert.notNull((Object)path, (String)"'path' must be not null");
        path = UrlUtils.normalizePath((String)path);
        return this.cache304ConfigMap.get(path.trim());
    }
}

