/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.util;

import icu.easyj.web.exception.RequestContextNotFoundException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class HttpUtils {
    @NonNull
    public static HttpServletRequest getRequest() throws RequestContextNotFoundException {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            throw new RequestContextNotFoundException();
        }
        return requestAttributes.getRequest();
    }

    @NonNull
    public static HttpServletResponse getResponse() throws RequestContextNotFoundException {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            throw new RequestContextNotFoundException();
        }
        HttpServletResponse response = requestAttributes.getResponse();
        if (response == null) {
            throw new RequestContextNotFoundException();
        }
        return response;
    }

    public static boolean isGetRequest(HttpServletRequest request) {
        return "GET".equalsIgnoreCase(request.getMethod());
    }

    public static boolean isGetRequest() {
        return HttpUtils.isGetRequest(HttpUtils.getRequest());
    }

    public static boolean isNotGetRequest(HttpServletRequest request) {
        return !HttpUtils.isGetRequest(request);
    }

    public static boolean isNotGetRequest() {
        return !HttpUtils.isGetRequest();
    }

    public static boolean isPostRequest(HttpServletRequest request) {
        return "POST".equalsIgnoreCase(request.getMethod());
    }

    public static boolean isPostRequest() {
        return HttpUtils.isPostRequest(HttpUtils.getRequest());
    }

    public static boolean isNotPostRequest(HttpServletRequest request) {
        return !HttpUtils.isPostRequest(request);
    }

    public static boolean isNotPostRequest() {
        return !HttpUtils.isPostRequest();
    }

    public static boolean isNoCacheRequest(HttpServletRequest request) {
        String cacheControl = request.getHeader("Cache-Control");
        if (!StringUtils.isEmpty((Object)cacheControl)) {
            return (cacheControl = cacheControl.toLowerCase()).contains("no-cache") || cacheControl.contains("no-store");
        }
        return false;
    }

    public static boolean isNoCacheRequest() {
        return HttpUtils.isNoCacheRequest(HttpUtils.getRequest());
    }

    public static void setResponseStatus304(HttpServletResponse response) {
        response.setStatus(HttpStatus.NOT_MODIFIED.value());
    }

    public static void setResponseStatus304() {
        HttpUtils.setResponseStatus304(HttpUtils.getResponse());
    }

    public static void setResponseNotAllowCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
    }

    public static boolean isDoExportRequest(HttpServletRequest request) {
        return "true".equalsIgnoreCase(request.getParameter("doExport"));
    }

    public static boolean isDoExportRequest() {
        return HttpUtils.isDoExportRequest(HttpUtils.getRequest());
    }

    public static String buildExportFileName(String fileNamePre, String fileSuffix) {
        if (!fileNamePre.endsWith("_")) {
            fileNamePre = fileNamePre + "_";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return fileNamePre + sdf.format(new Date()) + (fileSuffix.charAt(0) != '.' ? Character.valueOf('.') : "") + fileSuffix;
    }
}

