/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.param.crypto.impls;

import icu.easyj.core.exception.ConfigurationException;
import icu.easyj.core.util.Base64Utils;
import icu.easyj.crypto.CryptoFactory;
import icu.easyj.crypto.symmetric.ISymmetricCrypto;
import icu.easyj.web.param.crypto.IParamCryptoHandler;
import icu.easyj.web.param.crypto.IParamCryptoHandlerProperties;
import icu.easyj.web.param.crypto.exception.ParamDecryptException;
import icu.easyj.web.param.crypto.exception.ParamEncryptException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.util.StringUtils;

public class DefaultParamCryptoHandlerImpl
implements IParamCryptoHandler {
    private final IParamCryptoHandlerProperties properties;
    private final ISymmetricCrypto symmetricCrypto;

    public DefaultParamCryptoHandlerImpl(IParamCryptoHandlerProperties properties) {
        this.checkProperties(properties);
        this.properties = properties;
        if (properties.getCharset() == null) {
            properties.setCharset(StandardCharsets.UTF_8);
        }
        this.symmetricCrypto = CryptoFactory.getSymmetricCrypto((String)properties.getAlgorithm(), (String)properties.getKey(), (String)properties.getIv(), (Charset)properties.getCharset());
    }

    private void checkProperties(IParamCryptoHandlerProperties properties) {
        if (!StringUtils.hasText((String)properties.getAlgorithm())) {
            throw new ConfigurationException("\u51fa\u5165\u53c2\u52a0\u5bc6\u89e3\u5bc6\u7b97\u6cd5\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u521b\u5efa\u5bf9\u79f0\u52a0\u5bc6\u7b97\u6cd5\u5b9e\u4f8b");
        }
        if (!StringUtils.hasText((String)properties.getKey())) {
            throw new ConfigurationException("\u51fa\u5165\u53c2\u52a0\u5bc6\u89e3\u5bc6\u5bc6\u94a5\u672a\u914d\u7f6e\uff0c\u65e0\u6cd5\u521b\u5efa\u5bf9\u79f0\u52a0\u5bc6\u7b97\u6cd5\u5b9e\u4f8b");
        }
    }

    @Override
    public String handleEscapedChars(String encryptedParam) {
        return Base64Utils.normalize((String)encryptedParam);
    }

    @Override
    public boolean checkFormat(String encryptedParam) {
        return Base64Utils.isBase64((CharSequence)encryptedParam);
    }

    @Override
    public String encrypt(String param) throws ParamEncryptException {
        return this.symmetricCrypto.encryptBase64(param, this.properties.getCharset());
    }

    @Override
    public String decrypt(String encryptedParam) throws ParamDecryptException {
        return this.symmetricCrypto.decryptBase64(encryptedParam, this.properties.getCharset());
    }
}

