/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.util.httpclient.impls;

import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.loader.condition.DependsOnClass;
import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.UrlUtils;
import icu.easyj.web.util.httpclient.IHttpClientService;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;

@LoadLevel(name="SpringWeb")
@DependsOnClass(value={RestTemplate.class})
class SpringWebHttpClientServiceImpl
implements IHttpClientService {
    private final RestTemplate restTemplate;

    public SpringWebHttpClientServiceImpl() {
        RestTemplate restTemplate = new RestTemplate();
        ((DefaultUriBuilderFactory)restTemplate.getUriTemplateHandler()).setEncodingMode(DefaultUriBuilderFactory.EncodingMode.NONE);
        this.restTemplate = restTemplate;
    }

    @Override
    public <T> T get(String url, @Nullable Map<String, String> queryStringMap, @Nullable MultiValueMap<String, String> headers, Class<T> responseClass) {
        url = UrlUtils.joinQueryString((String)url, queryStringMap);
        if (MapUtils.isEmpty(headers)) {
            return (T)this.restTemplate.getForObject(url, responseClass, new Object[0]);
        }
        HttpEntity entity = new HttpEntity(headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, responseClass, new Object[0]);
        return (T)response.getBody();
    }

    @Override
    public <T> T post(String url, @Nullable Object requestBody, @Nullable MultiValueMap<String, String> headers, Class<T> responseClass) {
        if (MapUtils.isEmpty(headers)) {
            return (T)this.restTemplate.postForObject(url, requestBody, responseClass, new Object[0]);
        }
        HttpEntity entity = new HttpEntity(requestBody, headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)entity, responseClass, new Object[0]);
        return (T)response.getBody();
    }
}

