/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.cache304;

import icu.easyj.core.util.DateUtils;
import icu.easyj.web.cache304.config.Cache304Config;
import java.util.Date;

abstract class CacheTimeComputer {
    CacheTimeComputer() {
    }

    static long computeTime(Date lastModified, Cache304Config config) {
        if (config.getCacheDays() > 0) {
            return CacheTimeComputer.computeCacheTimeByCacheDays(lastModified, config.getCacheDays());
        }
        return 1000L * CacheTimeComputer.normalizeCacheSeconds(config.getCacheSeconds());
    }

    private static long computeCacheTimeByCacheDays(Date time, int cacheDays) {
        long endTimeOfToday = DateUtils.getTomorrowDate((Date)time).getTime();
        long remainingTime = endTimeOfToday - time.getTime();
        if (remainingTime < 600000L) {
            return 600000L;
        }
        return remainingTime + (long)(cacheDays - 1) * 86400000L;
    }

    public static long normalizeCacheSeconds(long cacheSeconds) {
        if (cacheSeconds <= 0L) {
            return 259200L;
        }
        return Math.min(cacheSeconds, 604800L);
    }
}

