/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.wrapper;

import icu.easyj.core.util.StringUtils;
import icu.easyj.web.servlet.BodyServletInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BodyHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private String body;
    @Nullable
    private ServletInputStream inputStream;
    @Nullable
    private BufferedReader reader;

    public BodyHttpServletRequestWrapper(HttpServletRequest request, String body) {
        super(request);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)body), (String)"'body' must not be null");
        this.body = body;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new BodyServletInputStream(this.body.getBytes(DEFAULT_CHARSET));
            this.body = null;
        }
        return this.inputStream;
    }

    public String getCharacterEncoding() {
        return DEFAULT_CHARSET.name();
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), DEFAULT_CHARSET));
        }
        return this.reader;
    }
}

