/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.cors;

import icu.easyj.core.util.ArrayUtils;
import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.web.cors.CorsProperties;
import icu.easyj.web.spring.WebMvcConfigurerAdapter;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.config.annotation.CorsRegistration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;

public class CorsWebMvcConfigurer
implements WebMvcConfigurerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CorsWebMvcConfigurer.class);
    private final CorsProperties properties;

    public CorsWebMvcConfigurer(CorsProperties properties) {
        this.properties = properties;
    }

    @Override
    public void addCorsMappings(CorsRegistry registry) {
        if (!this.properties.isEnabled() || StringUtils.isBlank((CharSequence)this.properties.getMapping())) {
            return;
        }
        CorsRegistration registration = registry.addMapping(this.properties.getMapping());
        if (this.properties.getAllowCredentials() != null) {
            registration.allowCredentials(this.properties.getAllowCredentials().booleanValue());
        }
        if (ArrayUtils.isNotEmpty((Object[])this.properties.getAllowedOrigins())) {
            registration.allowedOrigins(this.properties.getAllowedOrigins());
        }
        if (ArrayUtils.isNotEmpty((Object[])this.properties.getAllowedOriginPatterns())) {
            try {
                ReflectionUtils.invokeMethod((Object)registration, (String)"allowedOriginPatterns", (Class[])new Class[]{String[].class}, (Object[])this.properties.getAllowedOriginPatterns());
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("Spring\u7248\u672c\u592a\u4f4e\uff0c\u65b9\u6cd5 'CorsRegistration.allowedOriginPatterns(String[])' \u4e0d\u5b58\u5728\uff0callowedOriginPatterns\u914d\u7f6e\u65e0\u6548\u3002");
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("\u8c03\u7528 'allowedOriginPatterns' \u65b9\u6cd5\u5931\u8d25", e);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])this.properties.getAllowedMethods())) {
            registration.allowedMethods(this.properties.getAllowedMethods());
        }
        if (ArrayUtils.isNotEmpty((Object[])this.properties.getAllowedHeaders())) {
            registration.allowedMethods(this.properties.getAllowedHeaders());
        }
        if (this.properties.getMaxAge() > 0L) {
            registration.maxAge(this.properties.getMaxAge());
        }
    }
}

