/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.wrapper;

import icu.easyj.core.util.StringUtils;
import icu.easyj.web.servlet.BodyServletInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BodyHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final int contentLength;
    @Nonnull
    private ServletInputStream inputStream;
    @Nullable
    private BufferedReader reader;

    public BodyHttpServletRequestWrapper(HttpServletRequest request, String body) {
        super(request);
        Assert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)body), (String)"'body' must not be null");
        byte[] bodyBytes = body.getBytes(DEFAULT_CHARSET);
        this.contentLength = bodyBytes.length;
        this.inputStream = new BodyServletInputStream(bodyBytes);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public BufferedReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), DEFAULT_CHARSET));
        }
        return this.reader;
    }

    public String getCharacterEncoding() {
        return DEFAULT_CHARSET.name();
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public long getContentLengthLong() {
        return this.contentLength;
    }

    public String getHeader(String name) {
        if ("Content-Length".equalsIgnoreCase(name)) {
            return String.valueOf(this.contentLength);
        }
        return super.getHeader(name);
    }

    public int getIntHeader(String name) {
        if ("Content-Length".equalsIgnoreCase(name)) {
            return this.contentLength;
        }
        return super.getIntHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        if ("Content-Length".equalsIgnoreCase(name)) {
            return Collections.enumeration(Collections.singletonList(String.valueOf(this.contentLength)));
        }
        return super.getHeaders(name);
    }
}

