/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.simplifier;

import icu.easyj.maven.plugin.mojo.simplifier.IPomSimplifier;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public abstract class AbstractPomSimplifier
implements IPomSimplifier {
    protected final Log log;
    protected final MavenProject project;
    protected final MavenProject parent;
    protected final Model originalModel;
    protected final Parent originalModelParent;
    protected final Model model;
    protected final Parent modelParent;
    private boolean isCopiedParentItems = false;
    private boolean isCopiedParentItemsForOpenSourceProject = false;
    private boolean isCopiedDependenciesVersion = false;

    protected AbstractPomSimplifier(MavenProject project, Log log) {
        this.project = project;
        this.parent = project.getParent();
        this.originalModel = project.getOriginalModel();
        this.originalModelParent = this.originalModel.getParent();
        this.model = project.getModel();
        this.modelParent = this.model.getParent();
        this.log = log;
    }

    public void copyParent() {
        if (this.isCopiedParentItems) {
            return;
        }
        this.isCopiedParentItems = true;
        this.log.info((CharSequence)"Copy parent items:");
        String[] itemNameArr = new String[]{"InceptionYear", "Contributors", "MailingLists", "CiManagement"};
        this.copyParentItems(itemNameArr);
        this.copyParentForOpenSourceProject();
    }

    public void copyParentForOpenSourceProject() {
        if (this.isCopiedParentItemsForOpenSourceProject) {
            return;
        }
        this.isCopiedParentItemsForOpenSourceProject = true;
        this.log.info((CharSequence)"Copy parent items for open source project:");
        String[] itemNameArr = new String[]{"Url", "Organization", "Licenses", "Developers", "Scm", "IssueManagement"};
        this.copyParentItems(itemNameArr);
    }

    private void copyParentItems(String ... itemNameArr) {
        for (String itemName : itemNameArr) {
            try {
                itemName = itemName.substring(0, 1).toUpperCase() + itemName.substring(1);
                Method getMethod = Model.class.getMethod("get" + itemName, new Class[0]);
                Object originalValue = getMethod.invoke((Object)this.originalModel, new Object[0]);
                Object value = getMethod.invoke((Object)this.model, new Object[0]);
                if (!this.isNullOrEmpty(originalValue) || this.isNullOrEmpty(value)) continue;
                this.log.info((CharSequence)("   Copy " + itemName + "."));
                Method setMethod = Model.class.getMethod("set" + itemName, value instanceof List ? List.class : (value instanceof Map ? Map.class : value.getClass()));
                setMethod.invoke((Object)this.originalModel, value);
            }
            catch (Exception e) {
                this.log.warn((CharSequence)("   Copy " + itemName + " failed:"), (Throwable)e);
            }
        }
    }

    private boolean isNullOrEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            String str = obj.toString();
            return str.isEmpty();
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            return list.isEmpty();
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return map.isEmpty();
        }
        return false;
    }

    public void copyGroupIdAndVersion() {
        if (!this.model.getGroupId().equals(this.originalModel.getGroupId())) {
            this.log.info((CharSequence)("Set groupId from '" + this.originalModel.getGroupId() + "' to '" + this.model.getGroupId() + "'."));
            this.originalModel.setGroupId(this.model.getGroupId());
        }
        if (!this.model.getVersion().equals(this.originalModel.getVersion())) {
            this.log.info((CharSequence)("Set version from '" + this.originalModel.getVersion() + "' to '" + this.model.getVersion() + "'."));
            this.originalModel.setVersion(this.model.getVersion());
        }
    }

    public void replaceParentRevision() {
        if (this.originalModelParent != null && "${revision}".equals(this.originalModelParent.getVersion())) {
            this.log.info((CharSequence)("Set parent version from '" + this.originalModelParent.getVersion() + "' to '" + this.modelParent.getVersion() + "'."));
            this.originalModelParent.setVersion(this.modelParent.getVersion());
        }
    }

    public void copyDependenciesGroupIdAndVersion() {
        if (!this.isNullOrEmpty(this.originalModel.getDependencies()) && !this.isCopiedDependenciesVersion) {
            this.isCopiedDependenciesVersion = true;
            this.log.info((CharSequence)("Copy dependencies groupId and version (" + this.originalModel.getDependencies().size() + "):"));
            for (int i = 0; i < this.originalModel.getDependencies().size(); ++i) {
                Dependency originalDependency = (Dependency)this.originalModel.getDependencies().get(i);
                Dependency dependency = (Dependency)this.model.getDependencies().get(i);
                if (dependency.getArtifactId().equals(originalDependency.getArtifactId())) {
                    this.log.info((CharSequence)("  Copy dependency groupId and version: " + dependency + " -> " + originalDependency));
                    originalDependency.setGroupId(dependency.getGroupId());
                    originalDependency.setVersion(dependency.getVersion());
                    continue;
                }
                this.log.warn((CharSequence)("  Copy dependency groupId and version failed: " + dependency + " != " + originalDependency));
            }
        }
    }

    public void removeParent() {
        if (this.originalModel.getParent() != null) {
            this.log.info((CharSequence)"Remove Parent.");
            this.originalModel.setParent(null);
            this.copyGroupIdAndVersion();
            this.copyDependenciesGroupIdAndVersion();
        }
    }

    public void revertParent() {
        if (this.originalModelParent != null && this.originalModel.getParent() == null) {
            this.log.info((CharSequence)"Revert Parent.");
            this.originalModel.setParent(this.originalModelParent);
            this.replaceParentRevision();
        }
    }

    public void removeBuild() {
        if (this.originalModel.getBuild() != null) {
            this.log.info((CharSequence)"Remove Build.");
            this.originalModel.setBuild(null);
        }
    }

    public void removeReporting() {
        if (this.originalModel.getReporting() != null) {
            this.log.info((CharSequence)"Remove Reporting.");
            this.originalModel.setReporting(null);
        }
    }

    public void removePrerequisites() {
        if (this.originalModel.getPrerequisites() != null) {
            this.log.info((CharSequence)"Remove Prerequisites.");
            this.originalModel.setPrerequisites(null);
        }
    }

    public void removeDistributionManagement() {
        if (this.originalModel.getDistributionManagement() != null) {
            this.log.info((CharSequence)"Remove DistributionManagement.");
            this.originalModel.setDistributionManagement(null);
        }
    }

    public void removeRepositories() {
        if (!this.isNullOrEmpty(this.originalModel.getRepositories())) {
            this.log.info((CharSequence)"Remove Repositories.");
            this.originalModel.setRepositories(null);
        }
    }

    public void removePluginRepositories() {
        if (!this.isNullOrEmpty(this.originalModel.getPluginRepositories())) {
            this.log.info((CharSequence)"Remove PluginRepositories.");
            this.originalModel.setPluginRepositories(null);
        }
    }

    public void removeProfiles() {
        if (!this.isNullOrEmpty(this.originalModel.getProfiles())) {
            this.log.info((CharSequence)"Remove Profiles.");
            this.originalModel.setProfiles(null);
        }
    }

    public void removeDependencies() {
        if (!this.isNullOrEmpty(this.originalModel.getDependencies())) {
            this.log.info((CharSequence)"Remove Dependencies.");
            this.originalModel.setDependencies(null);
        }
    }

    public void removeDependencyManagement() {
        if (this.originalModel.getDependencyManagement() != null) {
            this.log.info((CharSequence)"Remove DependencyManagement.");
            this.originalModel.setDependencyManagement(null);
        }
    }

    public void removeProperties() {
        if (!this.isNullOrEmpty(this.originalModel.getProperties())) {
            this.log.info((CharSequence)"Remove Properties.");
            this.originalModel.setProperties(null);
        }
    }

    public void resetName() {
        if (!this.isNullOrEmpty(this.model.getName()) && !this.model.getName().equals(this.originalModel.getName())) {
            this.log.info((CharSequence)"Reset Name.");
            this.originalModel.setName(this.model.getName());
        }
    }

    public void resetDependencyManagement() {
        if (!this.isNullOrEmpty(this.model.getDependencyManagement()) && this.model.getDependencyManagement() != this.originalModel.getDependencyManagement()) {
            this.log.info((CharSequence)"Reset DependencyManagement.");
            this.originalModel.setDependencyManagement(this.model.getDependencyManagement());
        }
    }
}

