/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.simplifier;

import icu.easyj.maven.plugin.mojo.SimplifyMode;
import icu.easyj.maven.plugin.mojo.simplifier.AbstractPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplifier.BomPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplifier.JarPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplifier.NoopPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplifier.ShadeJarPomSimplifier;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public abstract class PomSimplifierFactory {
    public static AbstractPomSimplifier create(MavenProject project, String modeStr, Log log) {
        SimplifyMode mode = null;
        if (modeStr == null || modeStr.isEmpty() || "auto".equalsIgnoreCase(modeStr)) {
            modeStr = project.getPackaging();
        }
        try {
            mode = SimplifyMode.getByModeStr(modeStr);
        }
        catch (Exception e) {
            log.warn((CharSequence)("Get the mode by string '" + modeStr + "' failed: " + e));
        }
        if (mode == null) {
            mode = SimplifyMode.NOOP;
        }
        return PomSimplifierFactory.createInternal(project, mode, log);
    }

    private static AbstractPomSimplifier createInternal(MavenProject project, SimplifyMode mode, Log log) {
        log.info((CharSequence)("The mode is " + (Object)((Object)mode)));
        switch (mode) {
            case JAR: {
                return new JarPomSimplifier(project, log);
            }
            case SHADE: {
                return new ShadeJarPomSimplifier(project, log);
            }
            case BOM: {
                return new BomPomSimplifier(project, log);
            }
        }
        return new NoopPomSimplifier(project, log);
    }
}

