/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.simplifier;

import icu.easyj.maven.plugin.mojo.SimplifyPomMojoConfig;
import icu.easyj.maven.plugin.mojo.simplifier.IPomSimplifier;
import icu.easyj.maven.plugin.mojo.utils.ObjectUtils;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public abstract class AbstractPomSimplifier
implements IPomSimplifier {
    protected final Log log;
    protected final SimplifyPomMojoConfig config;
    protected final MavenProject project;
    protected final MavenProject parent;
    protected final Model originalModel;
    protected final Parent originalModelParent;
    protected final List<Dependency> originalDependencies;
    protected final Model model;
    protected final Parent modelParent;
    private boolean isCopiedParentItems = false;
    private boolean isCopiedParentItemsForOpenSourceProject = false;
    private boolean isResetDependencies = false;

    protected AbstractPomSimplifier(MavenProject project, SimplifyPomMojoConfig config, Log log) {
        this.project = project;
        this.parent = project.getParent();
        this.originalModel = project.getOriginalModel();
        this.originalModelParent = this.originalModel.getParent();
        this.originalDependencies = this.originalModel.getDependencies();
        this.model = project.getModel();
        this.modelParent = this.model.getParent();
        this.config = config;
        this.log = log;
    }

    @Override
    public void afterSimplify() {
        this.replaceParentRevision();
        this.resetNameAndDescription();
        this.optimizeDependencies();
    }

    @Override
    public void doSimplifyByConfig() {
        if (this.config.isOpenSourceProject()) {
            this.copyProjectInfoFromParentForOpenSourceProject();
        }
        this.optimizeDependenciesByConfig();
    }

    private void copyParentItems(String ... itemNameArr) {
        for (String itemName : itemNameArr) {
            try {
                itemName = itemName.substring(0, 1).toUpperCase() + itemName.substring(1);
                Method getMethod = Model.class.getMethod("get" + itemName, new Class[0]);
                Object originalValue = getMethod.invoke((Object)this.originalModel, new Object[0]);
                Object value = getMethod.invoke((Object)this.model, new Object[0]);
                if (!ObjectUtils.isEmpty(originalValue) || !ObjectUtils.isNotEmpty(value)) continue;
                this.log.info((CharSequence)("   Copy " + itemName + "."));
                Method setMethod = Model.class.getMethod("set" + itemName, value instanceof List ? List.class : (value instanceof Map ? Map.class : value.getClass()));
                setMethod.invoke((Object)this.originalModel, value);
            }
            catch (Exception e) {
                this.log.warn((CharSequence)("   Copy " + itemName + " failed:"), (Throwable)e);
            }
        }
    }

    private int getDependenciesSize(DependencyManagement dm) {
        if (dm == null) {
            return 0;
        }
        return this.getDependenciesSize(dm.getDependencies());
    }

    private int getDependenciesSize(List<Dependency> dependencies) {
        if (dependencies == null) {
            return 0;
        }
        return dependencies.size();
    }

    protected void printLine() {
        this.log.info((CharSequence)"-------------------------------------------");
    }

    public void removeParent() {
        if (this.originalModel.getParent() != null) {
            this.printLine();
            this.log.info((CharSequence)"Remove Parent.");
            this.originalModel.setParent(null);
            this.resetArtifactIdentification();
            this.resetDependencyManagement();
            this.resetDependencies();
            this.printLine();
        }
    }

    public void replaceParentRevision() {
        if (this.originalModel.getParent() != null && this.originalModelParent != null && "${revision}".equals(this.originalModelParent.getVersion())) {
            this.log.info((CharSequence)("Set parent version from '" + this.originalModelParent.getVersion() + "' to '" + this.modelParent.getVersion() + "'."));
            this.originalModelParent.setVersion(this.modelParent.getVersion());
        }
    }

    private void resetArtifactIdentification() {
        if (!this.model.getGroupId().equals(this.originalModel.getGroupId())) {
            this.log.info((CharSequence)("Set GroupId from '" + this.originalModel.getGroupId() + "' to '" + this.model.getGroupId() + "'."));
            this.originalModel.setGroupId(this.model.getGroupId());
        }
        if (!this.model.getArtifactId().equals(this.originalModel.getArtifactId())) {
            this.log.info((CharSequence)("Set ArtifactId from '" + this.originalModel.getArtifactId() + "' to '" + this.model.getArtifactId() + "'."));
            this.originalModel.setArtifactId(this.model.getArtifactId());
        }
        if (!this.model.getVersion().equals(this.originalModel.getVersion())) {
            this.log.info((CharSequence)("Set Version from '" + this.originalModel.getVersion() + "' to '" + this.model.getVersion() + "'."));
            this.originalModel.setVersion(this.model.getVersion());
        }
        if (ObjectUtils.isNotEmpty(this.model.getPackaging()) && !this.model.getPackaging().equals(this.originalModel.getPackaging()) && !"jar".equalsIgnoreCase(this.model.getPackaging())) {
            this.log.info((CharSequence)("Set Packaging from '" + this.originalModel.getPackaging() + "' to '" + this.model.getPackaging() + "'."));
            this.originalModel.setPackaging(this.model.getPackaging());
        }
    }

    public void resetNameAndDescription() {
        if (ObjectUtils.isNotEmpty(this.model.getName()) && ObjectUtils.isNotEmpty(this.originalModel.getName()) && !this.model.getName().equals(this.originalModel.getName())) {
            this.log.info((CharSequence)("Set Name from '" + this.originalModel.getName() + "' to '" + this.model.getName() + "'."));
            this.originalModel.setName(this.model.getName());
        }
        if (ObjectUtils.isNotEmpty(this.model.getDescription()) && ObjectUtils.isNotEmpty(this.originalModel.getDescription()) && !this.model.getDescription().equals(this.originalModel.getDescription())) {
            this.log.info((CharSequence)("Set Description from '" + this.originalModel.getDescription() + "' to '" + this.model.getDescription() + "'."));
            this.originalModel.setDescription(this.model.getDescription());
        }
    }

    public void copyProjectInfoFromParentForOpenSourceProject() {
        if (this.isCopiedParentItemsForOpenSourceProject && !this.config.isOpenSourceProject()) {
            return;
        }
        this.isCopiedParentItemsForOpenSourceProject = true;
        this.printLine();
        this.log.info((CharSequence)"Copy project info from parent for open source project.");
        String[] itemNameArr = new String[]{"Url", "Licenses", "Developers", "Scm", "Organization", "IssueManagement"};
        this.copyParentItems(itemNameArr);
        this.printLine();
    }

    public void copyProjectInfoFromParent() {
        if (this.isCopiedParentItems && !this.config.isOpenSourceProject()) {
            return;
        }
        this.isCopiedParentItems = true;
        this.printLine();
        this.log.info((CharSequence)"Copy project info from parent:");
        String[] itemNameArr = new String[]{"InceptionYear", "Contributors", "MailingLists", "CiManagement"};
        this.copyParentItems(itemNameArr);
        this.copyProjectInfoFromParentForOpenSourceProject();
        this.printLine();
    }

    public void removeDependencyManagement() {
        if (this.originalModel.getDependencyManagement() != null) {
            this.resetDependencies();
            this.log.info((CharSequence)"Remove DependencyManagement.");
            this.originalModel.setDependencyManagement(null);
        } else {
            this.resetDependencies();
        }
    }

    public void resetDependencyManagement() {
        if (ObjectUtils.isNotEmpty(this.model.getDependencyManagement()) && this.model.getDependencyManagement() != this.originalModel.getDependencyManagement()) {
            int originalSize = this.getDependenciesSize(this.originalModel.getDependencyManagement());
            int size = this.getDependenciesSize(this.model.getDependencyManagement());
            this.log.info((CharSequence)("Reset DependencyManagement: " + originalSize + " -> " + size));
            this.originalModel.setDependencyManagement(this.model.getDependencyManagement());
        }
    }

    public void removeDependencies() {
        if (ObjectUtils.isNotEmpty(this.originalModel.getDependencies())) {
            this.log.info((CharSequence)"Remove Dependencies.");
            this.originalModel.setDependencies(null);
        }
    }

    public void resetDependencies() {
        if (this.isResetDependencies) {
            return;
        }
        this.isResetDependencies = true;
        if (!ObjectUtils.isEmpty(this.originalModel.getDependencies())) {
            this.printLine();
            this.log.info((CharSequence)("Copy dependencies groupId and version (" + this.originalModel.getDependencies().size() + "):"));
            for (int i = 0; i < this.model.getDependencies().size(); ++i) {
                Dependency dependency = (Dependency)this.model.getDependencies().get(i);
                if (i < this.originalModel.getDependencies().size()) {
                    Dependency originalDependency = (Dependency)this.originalModel.getDependencies().get(i);
                    if (dependency.getArtifactId().equals(originalDependency.getArtifactId())) {
                        this.log.info((CharSequence)("  Copy dependency groupId and version and exclusions: " + dependency + " -> " + originalDependency));
                        originalDependency.setGroupId(dependency.getGroupId());
                        originalDependency.setVersion(dependency.getVersion());
                        originalDependency.setExclusions(dependency.getExclusions());
                        continue;
                    }
                    this.log.warn((CharSequence)("  Copy dependency groupId and version failed: " + dependency + " != " + originalDependency));
                    continue;
                }
                if (this.isNeedRemoved(dependency)) continue;
                this.log.info((CharSequence)("  Add dependency: " + dependency));
                this.originalModel.getDependencies().add(dependency);
            }
            this.printLine();
        }
    }

    protected void optimizeDependencies() {
        if (ObjectUtils.isEmpty(this.originalModel.getDependencies())) {
            return;
        }
        for (Dependency dependency : this.originalModel.getDependencies()) {
            if (!"compile".equalsIgnoreCase(dependency.getScope())) continue;
            dependency.setScope(null);
        }
    }

    protected void optimizeDependenciesByConfig() {
        if (ObjectUtils.isEmpty(this.originalModel.getDependencies())) {
            return;
        }
        int size = this.originalModel.getDependencies().size();
        this.printLine();
        for (int i = 0; i < this.originalModel.getDependencies().size(); ++i) {
            Dependency dependency = (Dependency)this.originalModel.getDependencies().get(i);
            if (!this.config.isKeepProvidedAndOptionalDependencies()) {
                if ("provided".equalsIgnoreCase(dependency.getScope())) {
                    this.removeOneDependencies(dependency, i--, "scope=provided");
                    continue;
                }
                if (dependency.isOptional()) {
                    this.removeOneDependencies(dependency, i--, "optional=true");
                    continue;
                }
            }
            if (!this.config.isKeepTestDependencies() && "test".equalsIgnoreCase(dependency.getScope())) {
                this.removeOneDependencies(dependency, i--, "scope=test");
                continue;
            }
            if (!this.config.isExcludeDependency(dependency)) continue;
            this.removeOneDependencies(dependency, i--, "isExclude=true");
        }
        if (size > this.originalModel.getDependencies().size()) {
            this.log.info((CharSequence)("Remove dependencies: " + (size - this.originalModel.getDependencies().size()) + "."));
        }
        this.printLine();
    }

    private boolean isNeedRemoved(Dependency dependency) {
        if (!this.config.isKeepProvidedAndOptionalDependencies()) {
            if ("provided".equalsIgnoreCase(dependency.getScope())) {
                return true;
            }
            if (dependency.isOptional()) {
                return true;
            }
        }
        if (!this.config.isKeepTestDependencies() && "test".equalsIgnoreCase(dependency.getScope())) {
            return true;
        }
        return this.config.isExcludeDependency(dependency);
    }

    private void removeOneDependencies(Dependency dependency, int i, String cause) {
        this.originalModel.getDependencies().remove(i);
        this.log.info((CharSequence)("Remove dependency by " + cause + ": " + dependency));
    }

    public void removeProperties() {
        if (ObjectUtils.isNotEmpty(this.originalModel.getProperties())) {
            this.log.info((CharSequence)"Remove Properties.");
            this.originalModel.setProperties(null);
            this.resetDependencies();
        }
    }

    public void removePrerequisites() {
        if (this.originalModel.getPrerequisites() != null) {
            this.log.info((CharSequence)"Remove Prerequisites.");
            this.originalModel.setPrerequisites(null);
        }
    }

    public void removeBuild() {
        if (this.originalModel.getBuild() != null) {
            this.log.info((CharSequence)"Remove Build.");
            this.originalModel.setBuild(null);
        }
    }

    public void removeReporting() {
        if (this.originalModel.getReporting() != null) {
            this.log.info((CharSequence)"Remove Reporting.");
            this.originalModel.setReporting(null);
        }
    }

    public void removeRepositories() {
        if (ObjectUtils.isNotEmpty(this.originalModel.getRepositories())) {
            this.log.info((CharSequence)"Remove Repositories.");
            this.originalModel.setRepositories(null);
        }
    }

    public void removePluginRepositories() {
        if (ObjectUtils.isNotEmpty(this.originalModel.getPluginRepositories())) {
            this.log.info((CharSequence)"Remove PluginRepositories.");
            this.originalModel.setPluginRepositories(null);
        }
    }

    public void removeDistributionManagement() {
        if (this.originalModel.getDistributionManagement() != null) {
            this.log.info((CharSequence)"Remove DistributionManagement.");
            this.originalModel.setDistributionManagement(null);
        }
    }

    public void removeProfiles() {
        if (ObjectUtils.isNotEmpty(this.originalModel.getProfiles())) {
            this.log.info((CharSequence)"Remove Profiles.");
            this.originalModel.setProfiles(null);
        }
    }
}

