/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo;

import icu.easyj.maven.plugin.mojo.AbstractSimplifyPomMojo;
import icu.easyj.maven.plugin.mojo.SimplifyPomMojoConfig;
import icu.easyj.maven.plugin.mojo.simplifier.AbstractPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplifier.PomSimplifierFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="simplify-pom", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class SimplifyPomMojo
extends AbstractSimplifyPomMojo {
    private static final int POM_WRITER_SIZE = 4096;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(property="maven.simplify.mode")
    private String simplifyMode;
    @Parameter(defaultValue="true")
    boolean updatePomFile;
    @Parameter(defaultValue="true")
    boolean isOpenSourceProject;
    @Parameter
    boolean removeParent;
    @Parameter(defaultValue="false")
    boolean keepProvidedAndOptionalDependencies;
    @Parameter(defaultValue="false")
    boolean keepTestDependencies;
    @Parameter
    Set<String> excludeDependencies;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Simplify-POM has been skipped.");
            return;
        }
        SimplifyPomMojoConfig config = new SimplifyPomMojoConfig(this);
        this.getLog().info((CharSequence)("Create PomSimplifier by mode: " + this.simplifyMode));
        AbstractPomSimplifier pomSimplifier = PomSimplifierFactory.create(this.project, this.simplifyMode, config, this.getLog());
        this.getLog().info((CharSequence)("Do simplify by the POM simplifier: " + pomSimplifier.getClass().getSimpleName()));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"==================================  start simplify  ==================================");
        pomSimplifier.beforeSimplify();
        pomSimplifier.doSimplify();
        pomSimplifier.doSimplifyByConfig();
        pomSimplifier.afterSimplify();
        this.getLog().info((CharSequence)"==================================   end  simplify  ==================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("Create the POM file '" + this.simplifiedPomFileName + "'."));
        File simplifiedPomFile = this.getSimplifiedPomFile();
        this.writePom(this.project.getOriginalModel(), simplifiedPomFile);
        if (this.updatePomFile) {
            this.getLog().info((CharSequence)("Set the POM file '" + this.simplifiedPomFileName + "' to the project object."));
            this.project.setFile(simplifiedPomFile);
        }
    }

    private void writePom(Model model, File pomFile) throws MojoExecutionException {
        boolean success;
        File parentFile = pomFile.getParentFile();
        if (!parentFile.exists() && !(success = parentFile.mkdirs())) {
            throw new MojoExecutionException("Failed to create directory " + pomFile.getParent());
        }
        MavenXpp3Writer pomWriter = new MavenXpp3Writer();
        StringWriter stringWriter = new StringWriter(4096);
        try {
            pomWriter.write((Writer)stringWriter, model);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Internal I/O error!", (Exception)e);
        }
        StringBuffer buffer = stringWriter.getBuffer();
        this.writeStringToFile(buffer.toString(), pomFile, model.getModelEncoding());
    }

    protected void writeStringToFile(String data, File file, String encoding) throws MojoExecutionException {
        Throwable throwable;
        byte[] binaryData;
        block36: {
            if (System.getProperty("os.name").contains("Windows")) {
                data = data.replaceAll("\r?\n", "\r\n");
            }
            try {
                binaryData = data.getBytes(encoding);
                if (file.isFile() && file.canRead() && file.length() == (long)binaryData.length) {
                    try {
                        throwable = null;
                        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                            byte[] buffer = new byte[binaryData.length];
                            inputStream.read(buffer);
                            if (Arrays.equals(buffer, binaryData)) {
                                this.getLog().debug((CharSequence)"Arrays.equals( buffer, binaryData ) ");
                                return;
                            }
                            this.getLog().debug((CharSequence)"Not Arrays.equals( buffer, binaryData ) ");
                            break block36;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (IOException e) {
                        this.getLog().debug((CharSequence)("Issue reading file: " + file.getPath()), (Throwable)e);
                    }
                    break block36;
                }
                this.getLog().debug((CharSequence)("file: " + file + ",file.length(): " + file.length() + ", binaryData.length: " + binaryData.length));
            }
            catch (IOException e) {
                throw new MojoExecutionException("cannot read String as bytes", (Exception)e);
            }
        }
        try {
            throwable = null;
            try (OutputStream outStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                outStream.write(binaryData);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write to " + file, (Exception)e);
        }
    }
}

