/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo;

import icu.easyj.maven.plugin.mojo.SimplifyMode;
import icu.easyj.maven.plugin.mojo.SimplifyPomMojo;
import icu.easyj.maven.plugin.mojo.utils.MatchUtils;
import icu.easyj.maven.plugin.mojo.utils.ObjectUtils;
import org.apache.maven.model.Dependency;

public class SimplifyPomMojoConfig {
    private final SimplifyPomMojo mojo;
    private SimplifyMode mode;

    public SimplifyPomMojoConfig(SimplifyPomMojo mojo) {
        this.mojo = mojo;
    }

    public SimplifyMode getMode() {
        return this.mode;
    }

    public void setMode(SimplifyMode mode) {
        this.mode = mode;
    }

    public boolean needRemoveParent() {
        return Boolean.TRUE.equals(this.mojo.removeParent);
    }

    public boolean isOpenSourceProject() {
        return this.mojo.isOpenSourceProject;
    }

    public boolean isKeepProvidedAndOptionalDependencies() {
        return this.mojo.keepProvidedAndOptionalDependencies;
    }

    public boolean isKeepTestDependencies() {
        return this.mojo.keepTestDependencies;
    }

    public boolean isExcludeDependency(Dependency dependency) {
        if (ObjectUtils.isEmpty(this.mojo.excludeDependencies)) {
            return false;
        }
        for (String exclude : this.mojo.excludeDependencies) {
            if (!MatchUtils.match(exclude, dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion())) continue;
            return true;
        }
        return false;
    }
}

