/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.simplifier;

import icu.easyj.maven.plugin.mojo.SimplifyMode;
import icu.easyj.maven.plugin.mojo.SimplifyPomMojoConfig;
import icu.easyj.maven.plugin.mojo.simplifier.AbstractPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplifier.jar.JarPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplifier.jar.ShadeJarPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplifier.mavenplugin.MavenPluginPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplifier.noop.NoopPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplifier.pom.BomPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplifier.pom.DependenciesPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplifier.pom.PomSimplifier;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public abstract class PomSimplifierFactory {
    public static AbstractPomSimplifier create(MavenProject project, String modeStr, SimplifyPomMojoConfig config, Log log) {
        SimplifyMode mode = null;
        if ("auto".equalsIgnoreCase(modeStr)) {
            modeStr = null;
            String artifactId = project.getArtifactId().toLowerCase();
            if ("pom".equals(project.getPackaging()) && artifactId.endsWith("-bom")) {
                modeStr = "bom";
                log.info((CharSequence)("Set mode to '" + modeStr + "', because the artifactId \"" + project.getArtifactId() + "\".endsWith(\"-bom\")."));
            } else if ("jar".equals(project.getPackaging()) && artifactId.endsWith("-all")) {
                modeStr = "shade";
                log.info((CharSequence)("Set mode to '" + modeStr + "', because the artifactId \"" + project.getArtifactId() + "\".endsWith(\"-all\")."));
            }
        }
        if (modeStr == null || modeStr.isEmpty()) {
            modeStr = project.getPackaging();
        } else {
            switch (modeStr.toLowerCase().replace('_', '-')) {
                case "pom": 
                case "jar": 
                case "war": 
                case "maven-plugin": {
                    if (modeStr.equalsIgnoreCase(project.getPackaging())) break;
                    log.warn((CharSequence)("The mode '" + modeStr + "' can't used for packaging '" + project.getPackaging() + "'."));
                    modeStr = project.getPackaging();
                    break;
                }
                case "shade": {
                    if ("jar".equals(project.getPackaging())) break;
                    log.warn((CharSequence)("The mode '" + modeStr + "' can't used for packaging '" + project.getPackaging() + "'."));
                    modeStr = project.getPackaging();
                    break;
                }
                case "dependencies": 
                case "bom": {
                    if ("pom".equals(project.getPackaging())) break;
                    log.warn((CharSequence)("The mode '" + modeStr + "' can't used for packaging '" + project.getPackaging() + "'."));
                    modeStr = project.getPackaging();
                    break;
                }
            }
        }
        try {
            mode = SimplifyMode.getByModeStr(modeStr);
        }
        catch (Exception e) {
            log.warn((CharSequence)("Get the mode by string '" + modeStr + "' failed: " + e));
        }
        if (mode == null) {
            mode = SimplifyMode.NOOP;
        }
        log.info((CharSequence)("The simplify mode is: " + (Object)((Object)mode)));
        config.setMode(mode);
        return PomSimplifierFactory.createInternal(project, config, log);
    }

    private static AbstractPomSimplifier createInternal(MavenProject project, SimplifyPomMojoConfig config, Log log) {
        switch (config.getMode()) {
            case JAR: 
            case WAR: {
                return new JarPomSimplifier(project, config, log);
            }
            case SHADE: {
                return new ShadeJarPomSimplifier(project, config, log);
            }
            case MAVEN_PLUGIN: {
                return new MavenPluginPomSimplifier(project, config, log);
            }
            case POM: {
                return new PomSimplifier(project, config, log);
            }
            case DEPENDENCIES: {
                return new DependenciesPomSimplifier(project, config, log);
            }
            case BOM: {
                return new BomPomSimplifier(project, config, log);
            }
        }
        return new NoopPomSimplifier(project, config, log);
    }
}

