/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.simplifier;

import icu.easyj.maven.plugin.mojo.SimplifyPomMojoConfig;
import icu.easyj.maven.plugin.mojo.simplifier.IPomSimplifier;
import icu.easyj.maven.plugin.mojo.utils.ObjectUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public abstract class AbstractPomSimplifier
implements IPomSimplifier {
    protected final Log log;
    protected final SimplifyPomMojoConfig config;
    protected final MavenProject project;
    protected final MavenProject parent;
    protected final Model originalModel;
    protected final Parent originalModelParent;
    protected final List<Dependency> originalDependencies;
    protected final Model model;
    protected final Parent modelParent;
    private boolean isCopiedParentItems = false;
    private boolean isCopiedParentItemsForOpenSourceProject = false;
    private boolean isResetDependencies = false;

    protected AbstractPomSimplifier(MavenProject project, SimplifyPomMojoConfig config, Log log) {
        this.project = project;
        this.parent = project.getParent();
        this.originalModel = project.getOriginalModel();
        this.originalModelParent = this.originalModel.getParent();
        this.originalDependencies = this.originalModel.getDependencies();
        this.model = project.getModel();
        this.modelParent = this.model.getParent();
        this.config = config;
        this.log = log;
    }

    @Override
    public void afterSimplify() {
        this.replaceParentRevision();
        this.removeGroupIdAndVersionIfEqualsToParent();
        this.optimizeDependencies();
        this.optimizeDependencyManagement();
    }

    @Override
    public void doSimplifyByConfig() {
        this.copyProjectInfoFromParentForOpenSourceProject();
        this.createPropertiesByConfig();
    }

    private void copyParentItems(String ... itemNameArr) {
        for (String itemName : itemNameArr) {
            try {
                itemName = itemName.substring(0, 1).toUpperCase() + itemName.substring(1);
                Method getMethod = Model.class.getMethod("get" + itemName, new Class[0]);
                Object originalValue = getMethod.invoke((Object)this.originalModel, new Object[0]);
                Object value = this.findParentValue(this.project.getParent(), getMethod);
                if (!ObjectUtils.isEmpty(originalValue) || !ObjectUtils.isNotEmpty(value)) continue;
                this.log.info((CharSequence)("   Copy " + itemName + "."));
                Method setMethod = Model.class.getMethod("set" + itemName, value instanceof List ? List.class : (value instanceof Map ? Map.class : value.getClass()));
                setMethod.invoke((Object)this.originalModel, value);
            }
            catch (Exception e) {
                this.log.warn((CharSequence)("   Copy " + itemName + " failed:"), (Throwable)e);
            }
        }
    }

    private Object findParentValue(MavenProject parent, Method getMethod) throws InvocationTargetException, IllegalAccessException {
        if (parent == null) {
            return null;
        }
        Object value = getMethod.invoke((Object)parent.getOriginalModel(), new Object[0]);
        if (ObjectUtils.isEmpty(value)) {
            return this.findParentValue(parent.getParent(), getMethod);
        }
        return value;
    }

    private int getDependenciesSize(DependencyManagement dm) {
        if (dm == null) {
            return 0;
        }
        return this.getDependenciesSize(dm.getDependencies());
    }

    private int getDependenciesSize(List<Dependency> dependencies) {
        if (dependencies == null) {
            return 0;
        }
        return dependencies.size();
    }

    protected String dependencyToString(Dependency dependency) {
        if (dependency == null) {
            return "null";
        }
        return "[" + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + (ObjectUtils.isEmpty(dependency.getType()) || "jar".equalsIgnoreCase(dependency.getType()) ? "" : ":" + dependency.getType()) + (ObjectUtils.isEmpty(dependency.getClassifier()) ? "" : ":" + dependency.getClassifier()) + (ObjectUtils.isEmpty(dependency.getScope()) ? "" : ":" + dependency.getScope()) + (ObjectUtils.isEmpty(dependency.getOptional()) ? "" : ":" + dependency.getOptional()) + "]";
    }

    protected String replaceVariable(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        Properties properties = this.model.getProperties();
        if (properties == null || properties.isEmpty()) {
            return str;
        }
        while (str.contains("${") && str.contains("}")) {
            int end;
            int start = str.indexOf("${");
            String varName = str.substring(start + 2, end = str.indexOf("}")).trim();
            String varValue = this.getProperty(varName);
            varValue = varValue == null ? "" : varValue.trim();
            str = str.substring(0, start) + varValue + str.substring(end + 1);
        }
        return str;
    }

    protected String getProjectProperty(String key) {
        if (key == null || key.isEmpty()) {
            return key;
        }
        switch (key.toLowerCase()) {
            case "project.groupid": 
            case "${project.groupid}": {
                return this.project.getGroupId();
            }
            case "project.artifactid": 
            case "${project.artifactid}": {
                return this.project.getArtifactId();
            }
            case "project.version": 
            case "${project.version}": {
                return this.project.getVersion();
            }
            case "project.parent.groupid": 
            case "${project.parent.groupid}": 
            case "parent.groupid": 
            case "${parent.groupid}": {
                return this.project.getParent() != null ? this.project.getParent().getGroupId() : this.project.getGroupId();
            }
            case "project.parent.artifactid": 
            case "${project.parent.artifactid}": 
            case "parent.artifactid": 
            case "${parent.artifactid}": {
                return this.project.getParent() != null ? this.project.getParent().getArtifactId() : this.project.getArtifactId();
            }
            case "project.parent.version": 
            case "${project.parent.version}": 
            case "parent.version": 
            case "${parent.version}": {
                return this.project.getParent() != null ? this.project.getParent().getVersion() : this.project.getVersion();
            }
        }
        return key;
    }

    protected String getProperty(String key) {
        if (key == null || key.isEmpty()) {
            return key;
        }
        String value = this.getProjectProperty(key);
        if (!key.equals(value)) {
            return value;
        }
        Properties properties = this.model.getProperties();
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        return this.model.getProperties().getProperty(key);
    }

    protected void printLine() {
        this.log.info((CharSequence)"-------------------------------------------");
    }

    public void removeParent() {
        if (this.originalModel.getParent() != null && !Boolean.FALSE.equals(this.config.needRemoveParent())) {
            this.log.info((CharSequence)"Remove Parent.");
            this.originalModel.setParent(null);
        }
        this.resetArtifactIdentification();
        this.resetNameAndDescription();
    }

    public void removeParentByConfig() {
        if (this.originalModel.getParent() != null && Boolean.TRUE.equals(this.config.needRemoveParent())) {
            this.removeParent();
        }
    }

    public void replaceParentRevision() {
        Properties originalProperties;
        Parent originalParent = this.originalModel.getParent();
        if (originalParent != null && "${revision}".equals(originalParent.getVersion())) {
            this.log.info((CharSequence)("Set parent version from '" + originalParent.getVersion() + "' to '" + this.modelParent.getVersion() + "'."));
            originalParent.setVersion(this.modelParent.getVersion());
        }
        if (ObjectUtils.isNotEmpty(originalProperties = this.originalModel.getProperties()) && originalProperties.containsKey("revision") && this.model.getVersion().equals(this.model.getProperties().getProperty("revision"))) {
            this.log.info((CharSequence)"Remove the special property '<revision>'.");
            originalProperties.remove("revision");
        }
    }

    public void removeParentRelativePath() {
        if (this.originalModel.getParent() != null && this.originalModel.getParent().getRelativePath() != null) {
            this.log.info((CharSequence)"Remove Parent RelativePath.");
            this.originalModel.getParent().setRelativePath(null);
        }
    }

    public void resetArtifactIdentification() {
        this.removeGroupIdAndVersionIfEqualsToParent();
        if (!this.model.getGroupId().equals(this.originalModel.getGroupId())) {
            this.log.info((CharSequence)("Set GroupId from '" + this.originalModel.getGroupId() + "' to '" + this.model.getGroupId() + "'."));
            this.originalModel.setGroupId(this.model.getGroupId());
        }
        if (!this.model.getArtifactId().equals(this.originalModel.getArtifactId())) {
            this.log.info((CharSequence)("Set ArtifactId from '" + this.originalModel.getArtifactId() + "' to '" + this.model.getArtifactId() + "'."));
            this.originalModel.setArtifactId(this.model.getArtifactId());
        }
        if (!this.model.getVersion().equals(this.originalModel.getVersion())) {
            this.log.info((CharSequence)("Set Version from '" + this.originalModel.getVersion() + "' to '" + this.model.getVersion() + "'."));
            this.originalModel.setVersion(this.model.getVersion());
        }
        if (ObjectUtils.isNotEmpty(this.model.getPackaging()) && !this.model.getPackaging().equals(this.originalModel.getPackaging()) && !"jar".equalsIgnoreCase(this.model.getPackaging())) {
            this.log.info((CharSequence)("Set Packaging from '" + this.originalModel.getPackaging() + "' to '" + this.model.getPackaging() + "'."));
            this.originalModel.setPackaging(this.model.getPackaging());
        }
    }

    public void resetVersion() {
        if (ObjectUtils.isNotEmpty(this.originalModel.getVersion()) && !this.model.getVersion().equals(this.originalModel.getVersion())) {
            this.log.info((CharSequence)("Set Version from '" + this.originalModel.getVersion() + "' to '" + this.model.getVersion() + "'."));
            this.originalModel.setVersion(this.model.getVersion());
        }
    }

    public void removeGroupIdAndVersionIfEqualsToParent() {
        if (this.originalModel.getParent() == null) {
            return;
        }
        Parent parent = this.model.getParent();
        if (parent.getGroupId().equals(this.model.getGroupId()) && ObjectUtils.isNotEmpty(this.originalModel.getGroupId())) {
            this.log.info((CharSequence)"Remove GroupId, because it's equals to the groupId of the parent.");
            this.originalModel.setGroupId(null);
        }
        if (parent.getVersion().equals(this.model.getVersion()) && ObjectUtils.isNotEmpty(this.originalModel.getVersion())) {
            this.log.info((CharSequence)"Remove Version, because it's equals to the version of the parent.");
            this.originalModel.setVersion(null);
        }
    }

    public void resetNameAndDescription() {
        if (ObjectUtils.isNotEmpty(this.model.getName()) && ObjectUtils.isNotEmpty(this.originalModel.getName()) && !this.model.getName().equals(this.originalModel.getName())) {
            this.log.info((CharSequence)("Set Name from '" + this.originalModel.getName() + "' to '" + this.model.getName() + "'."));
            this.originalModel.setName(this.model.getName());
        }
        if (ObjectUtils.isNotEmpty(this.model.getDescription()) && ObjectUtils.isNotEmpty(this.originalModel.getDescription()) && !this.model.getDescription().equals(this.originalModel.getDescription())) {
            this.log.info((CharSequence)("Set Description from '" + this.originalModel.getDescription() + "' to '" + this.model.getDescription() + "'."));
            this.originalModel.setDescription(this.model.getDescription());
        }
    }

    public void copyProjectInfoFromParentForOpenSourceProject() {
        if (this.isCopiedParentItemsForOpenSourceProject || !this.config.isOpenSourceProject() || this.originalModel.getParent() != null) {
            return;
        }
        this.isCopiedParentItemsForOpenSourceProject = true;
        this.printLine();
        this.log.info((CharSequence)"Copy project info from parent for the open source project:");
        String[] itemNameArr = new String[]{"Url", "Licenses", "Developers", "Scm", "Organization", "IssueManagement"};
        this.copyParentItems(itemNameArr);
        this.printLine();
    }

    public void copyProjectInfoFromParent() {
        if (this.isCopiedParentItems || !this.config.isOpenSourceProject() || this.originalModel.getParent() != null) {
            return;
        }
        this.isCopiedParentItems = true;
        this.printLine();
        this.log.info((CharSequence)"Copy project info from parent:");
        String[] itemNameArr = new String[]{"InceptionYear", "Contributors", "MailingLists", "CiManagement"};
        this.copyParentItems(itemNameArr);
        this.copyProjectInfoFromParentForOpenSourceProject();
        this.printLine();
    }

    public void removeDependencyManagement() {
        if (this.originalModel.getDependencyManagement() != null) {
            this.resetDependencies();
            this.log.info((CharSequence)"Remove DependencyManagement.");
            this.originalModel.setDependencyManagement(null);
        } else {
            this.resetDependencies();
        }
    }

    public void resetDependencyManagement() {
        if (ObjectUtils.isNotEmpty(this.model.getDependencyManagement()) && this.model.getDependencyManagement() != this.originalModel.getDependencyManagement()) {
            int originalSize = this.getDependenciesSize(this.originalModel.getDependencyManagement());
            int size = this.getDependenciesSize(this.model.getDependencyManagement());
            this.log.info((CharSequence)("Reset DependencyManagement: " + originalSize + " -> " + size));
            this.originalModel.setDependencyManagement(this.model.getDependencyManagement());
        }
    }

    public void optimizeDependencyManagement() {
        DependencyManagement dm = this.originalModel.getDependencyManagement();
        if (dm == null || ObjectUtils.isEmpty(dm.getDependencies())) {
            return;
        }
        this.optimizeDependencies(dm.getDependencies());
    }

    public void removeDependencies() {
        if (ObjectUtils.isNotEmpty(this.originalModel.getDependencies())) {
            this.log.info((CharSequence)"Remove Dependencies.");
            this.originalModel.setDependencies(null);
        }
    }

    public void clearDependencyScopeCompileAndOptionalFalse(Dependency dependency) {
        if ("compile".equalsIgnoreCase(dependency.getScope())) {
            dependency.setScope(null);
        }
        if (!"true".equalsIgnoreCase(dependency.getOptional())) {
            dependency.setOptional(null);
        }
    }

    public void clearDependencyScopeCompileAndOptionalFalse(List<Dependency> dependencies) {
        if (ObjectUtils.isEmpty(dependencies)) {
            return;
        }
        for (Dependency dependency : dependencies) {
            this.clearDependencyScopeCompileAndOptionalFalse(dependency);
        }
    }

    public void resetDependencies() {
        if (this.isResetDependencies) {
            return;
        }
        this.isResetDependencies = true;
        if (ObjectUtils.isEmpty(this.originalModel.getDependencies())) {
            return;
        }
        int originalSize = this.getDependenciesSize(this.originalModel.getDependencies());
        this.printLine();
        this.log.info((CharSequence)("Reset dependencies: groupId, version, exclusions (Contains " + this.originalModel.getDependencies().size() + " dependencies)"));
        int i = 0;
        int n = 0;
        while (i < this.model.getDependencies().size()) {
            Dependency originalDependency;
            Dependency dependency = (Dependency)this.model.getDependencies().get(i);
            if (i < originalSize) {
                originalDependency = (Dependency)this.originalModel.getDependencies().get(n);
                String beforeDependencyStr = this.dependencyToString(originalDependency);
                originalDependency.setGroupId(this.replaceVariable(originalDependency.getGroupId()));
                originalDependency.setArtifactId(this.replaceVariable(originalDependency.getArtifactId()));
                if (dependency.getGroupId().equals(originalDependency.getGroupId()) && dependency.getArtifactId().equals(originalDependency.getArtifactId())) {
                    if (!this.config.isKeepProvidedDependencies() && "provided".equalsIgnoreCase(dependency.getScope())) {
                        this.removeOneDependencies(dependency, n--, "scope=provided");
                    } else if (!this.config.isKeepTestDependencies() && "test".equalsIgnoreCase(dependency.getScope())) {
                        this.removeOneDependencies(dependency, n--, "scope=test");
                    } else if (!this.config.isKeepOptionalDependencies() && dependency.isOptional()) {
                        this.removeOneDependencies(dependency, n--, "optional=true");
                    } else if (this.config.isExcludeDependency(dependency)) {
                        this.removeOneDependencies(dependency, n--, "isExclude=true");
                    } else {
                        originalDependency.setType(dependency.getType());
                        originalDependency.setVersion(dependency.getVersion());
                        originalDependency.setClassifier(dependency.getClassifier());
                        originalDependency.setScope("compile".equalsIgnoreCase(dependency.getScope()) ? null : dependency.getScope());
                        originalDependency.setOptional(dependency.isOptional() ? "true" : null);
                        originalDependency.setSystemPath(dependency.getSystemPath());
                        originalDependency.setExclusions(dependency.getExclusions());
                        this.log.info((CharSequence)("  Reset dependency: " + beforeDependencyStr + " -> " + this.dependencyToString(originalDependency)));
                    }
                } else {
                    this.log.info((CharSequence)("  Remove duple dependency: " + this.dependencyToString(originalDependency)));
                    this.originalModel.getDependencies().remove(n--);
                    --originalSize;
                    --i;
                }
            } else if (!this.isNeedRemoved(dependency)) {
                originalDependency = this.copyDependency(dependency);
                this.log.info((CharSequence)("  Add dependency: " + this.dependencyToString(originalDependency)));
                this.originalModel.getDependencies().add(originalDependency);
            }
            ++i;
            ++n;
        }
        this.log.info((CharSequence)("Remaining " + this.originalModel.getDependencies().size() + " dependencies."));
        this.printLine();
    }

    protected Dependency copyDependency(Dependency dependency) {
        Dependency originalDependency = new Dependency();
        originalDependency.setGroupId(dependency.getGroupId());
        originalDependency.setArtifactId(dependency.getArtifactId());
        originalDependency.setVersion(dependency.getVersion());
        originalDependency.setType(dependency.getType());
        originalDependency.setClassifier(dependency.getClassifier());
        originalDependency.setScope("compile".equalsIgnoreCase(dependency.getScope()) ? null : dependency.getScope());
        originalDependency.setOptional(dependency.isOptional() ? "true" : null);
        originalDependency.setSystemPath(dependency.getSystemPath());
        originalDependency.setExclusions(new ArrayList(dependency.getExclusions()));
        return originalDependency;
    }

    protected void optimizeDependencies() {
        this.optimizeDependencies(this.originalModel.getDependencies());
    }

    private void optimizeDependencies(List<Dependency> dependencies) {
        if (ObjectUtils.isEmpty(dependencies)) {
            return;
        }
        Function<String, String> fun = this.originalModel.getParent() != null ? this::getProjectProperty : this::replaceVariable;
        for (Dependency dependency : dependencies) {
            dependency.setGroupId(fun.apply(dependency.getGroupId()));
            dependency.setArtifactId(fun.apply(dependency.getArtifactId()));
            dependency.setVersion(fun.apply(dependency.getVersion()));
            this.clearDependencyScopeCompileAndOptionalFalse(dependency);
        }
    }

    private boolean isNeedRemoved(Dependency dependency) {
        if (!this.config.isKeepProvidedDependencies() && "provided".equalsIgnoreCase(dependency.getScope())) {
            return true;
        }
        if (!this.config.isKeepTestDependencies() && "test".equalsIgnoreCase(dependency.getScope())) {
            return true;
        }
        if (!this.config.isKeepOptionalDependencies() && dependency.isOptional()) {
            return true;
        }
        return this.config.isExcludeDependency(dependency);
    }

    private void removeOneDependencies(Dependency dependency, int n, String cause) {
        this.originalModel.getDependencies().remove(n);
        this.log.info((CharSequence)("  Remove dependency by " + cause + ": " + this.dependencyToString(dependency)));
    }

    public void removeProperties() {
        if (ObjectUtils.isNotEmpty(this.originalModel.getProperties())) {
            this.log.info((CharSequence)"Remove Properties.");
            this.originalModel.setProperties(null);
            this.resetDependencies();
        }
    }

    public void createPropertiesByConfig() {
        block10: {
            block9: {
                if (this.originalModel.getProperties() != null) break block9;
                if (this.originalModel.getBuild() != null && ObjectUtils.isNotEmpty(this.originalModel.getBuild().getPlugins())) {
                    for (Plugin plugin : this.originalModel.getBuild().getPlugins()) {
                        if (!"icu.easyj.maven.plugins".equalsIgnoreCase(plugin.getGroupId()) || !"easyj-maven-plugin".equalsIgnoreCase(plugin.getArtifactId()) || !(plugin.getConfiguration() instanceof Xpp3Dom)) continue;
                        this.removeConfiguration(plugin, "createProperties", "removeParent");
                        break;
                    }
                }
                return;
            }
            try {
                if (!ObjectUtils.isNotEmpty(this.config.getCreateProperties())) break block10;
                this.config.getCreateProperties().forEach((key, value) -> {
                    if (ObjectUtils.isNotEmpty(key) && ObjectUtils.isNotEmpty(value)) {
                        this.log.info((CharSequence)("Create Properties: " + key + " = " + value));
                        this.originalModel.getProperties().put(key, value);
                    }
                });
            }
            catch (Throwable throwable) {
                if (this.originalModel.getBuild() != null && ObjectUtils.isNotEmpty(this.originalModel.getBuild().getPlugins())) {
                    for (Plugin plugin : this.originalModel.getBuild().getPlugins()) {
                        if (!"icu.easyj.maven.plugins".equalsIgnoreCase(plugin.getGroupId()) || !"easyj-maven-plugin".equalsIgnoreCase(plugin.getArtifactId()) || !(plugin.getConfiguration() instanceof Xpp3Dom)) continue;
                        this.removeConfiguration(plugin, "createProperties", "removeParent");
                        break;
                    }
                }
                throw throwable;
            }
        }
        if (this.originalModel.getBuild() != null && ObjectUtils.isNotEmpty(this.originalModel.getBuild().getPlugins())) {
            for (Plugin plugin : this.originalModel.getBuild().getPlugins()) {
                if (!"icu.easyj.maven.plugins".equalsIgnoreCase(plugin.getGroupId()) || !"easyj-maven-plugin".equalsIgnoreCase(plugin.getArtifactId()) || !(plugin.getConfiguration() instanceof Xpp3Dom)) continue;
                this.removeConfiguration(plugin, "createProperties", "removeParent");
                break;
            }
        }
    }

    private void removeConfiguration(Plugin plugin, String ... removeConfigNames) {
        HashSet<String> removeConfigSet = new HashSet<String>(Arrays.asList(removeConfigNames));
        removeConfigSet.remove(null);
        Xpp3Dom configDom = (Xpp3Dom)plugin.getConfiguration();
        for (int i = 0; i < configDom.getChildren().length; ++i) {
            Xpp3Dom child = configDom.getChildren()[i];
            if (!removeConfigSet.contains(child.getName())) continue;
            this.log.info((CharSequence)("Remove one config '" + child.getName() + "' from the plugin '" + plugin.getId() + "'."));
            configDom.removeChild(i--);
        }
        if (configDom.getChildren().length == 0) {
            this.log.info((CharSequence)("Remove Configuration from the plugin '" + plugin.getId() + "'."));
            plugin.setConfiguration(null);
        }
    }

    public void removePrerequisites() {
        if (this.originalModel.getPrerequisites() != null) {
            this.log.info((CharSequence)"Remove Prerequisites.");
            this.originalModel.setPrerequisites(null);
        }
    }

    public void removeBuild() {
        if (this.originalModel.getBuild() != null) {
            this.log.info((CharSequence)"Remove Build.");
            this.originalModel.setBuild(null);
        }
    }

    public void removeReporting() {
        if (this.originalModel.getReporting() != null) {
            this.log.info((CharSequence)"Remove Reporting.");
            this.originalModel.setReporting(null);
        }
    }

    public void removeReports() {
        if (this.originalModel.getReports() != null) {
            this.originalModel.setReports(null);
        }
    }

    public void removeRepositories() {
        if (ObjectUtils.isNotEmpty(this.originalModel.getRepositories())) {
            this.log.info((CharSequence)"Remove Repositories.");
            this.originalModel.setRepositories(null);
        }
    }

    public void removePluginRepositories() {
        if (ObjectUtils.isNotEmpty(this.originalModel.getPluginRepositories())) {
            this.log.info((CharSequence)"Remove PluginRepositories.");
            this.originalModel.setPluginRepositories(null);
        }
    }

    public void removeDistributionManagement() {
        if (this.originalModel.getDistributionManagement() != null) {
            this.log.info((CharSequence)"Remove DistributionManagement.");
            this.originalModel.setDistributionManagement(null);
        }
    }

    public void removeProfiles() {
        if (ObjectUtils.isNotEmpty(this.originalModel.getProfiles())) {
            this.log.info((CharSequence)"Remove Profiles.");
            this.originalModel.setProfiles(null);
        }
    }
}

