/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo;

import icu.easyj.maven.plugin.mojo.AbstractSimplifyPomMojo;
import icu.easyj.maven.plugin.mojo.SimplifyPomMojoConfig;
import icu.easyj.maven.plugin.mojo.simplifier.AbstractPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplifier.PomSimplifierFactory;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="simplify-pom", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class SimplifyPomMojo
extends AbstractSimplifyPomMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="auto", property="maven.simplify.mode")
    private String simplifyMode;
    @Parameter(defaultValue="true")
    boolean updatePomFile;
    @Parameter(defaultValue="true")
    boolean isOpenSourceProject;
    @Parameter
    Boolean removeParent;
    @Parameter(defaultValue="false")
    boolean keepProvidedDependencies;
    @Parameter(defaultValue="false")
    boolean keepOptionalDependencies;
    @Parameter(defaultValue="false")
    boolean keepTestDependencies;
    @Parameter
    Set<String> excludeDependencies;
    @Parameter
    Map<String, String> createProperties;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Simplify-POM has been skipped.");
            return;
        }
        SimplifyPomMojoConfig config = new SimplifyPomMojoConfig(this);
        this.getLog().info((CharSequence)("Create PomSimplifier by mode: " + this.simplifyMode));
        AbstractPomSimplifier pomSimplifier = PomSimplifierFactory.create(this.project, this.simplifyMode, config, this.getLog());
        this.getLog().info((CharSequence)("Do simplify by the POM simplifier: " + pomSimplifier.getClass().getSimpleName()));
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"==================================  start simplify  ==================================");
        pomSimplifier.beforeSimplify();
        pomSimplifier.doSimplify();
        pomSimplifier.doSimplifyByConfig();
        pomSimplifier.afterSimplify();
        this.getLog().info((CharSequence)"==================================   end  simplify  ==================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("Create the POM file '" + this.simplifiedPomFileName + "'."));
        File simplifiedPomFile = this.getSimplifiedPomFile();
        this.writePom(this.project.getOriginalModel(), simplifiedPomFile);
        if (this.updatePomFile) {
            this.getLog().info((CharSequence)("Set the POM file '" + this.simplifiedPomFileName + "' to the project object."));
            this.project.setFile(simplifiedPomFile);
        }
    }
}

