/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo;

import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="undeploy-spring-boot-jar", defaultPhase=LifecyclePhase.INSTALL, threadSafe=true)
public class UndeploySpringBootJarMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        boolean isSpringBootJar = false;
        List plugins = this.project.getBuildPlugins();
        for (Plugin plugin : plugins) {
            if (!"org.springframework.boot".equalsIgnoreCase(plugin.getGroupId()) || !"spring-boot-maven-plugin".equalsIgnoreCase(plugin.getArtifactId())) continue;
            isSpringBootJar = true;
            break;
        }
        if (isSpringBootJar) {
            this.getLog().info((CharSequence)"The current project is a springboot application, it will not be deployed.");
            this.project.getProperties().put("maven.deploy.skip", "true");
            this.getLog().info((CharSequence)"Put properties 'maven.deploy.skip = true'.");
        }
    }
}

