/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo;

import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="undeploy-spring-boot-jar", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class UndeploySpringBootJarMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="true")
    private boolean skipInstall;
    @Parameter(defaultValue="true")
    private boolean skipDeploy;

    public void execute() throws MojoExecutionException {
        if (!this.skipInstall && !this.skipDeploy) {
            this.getLog().info((CharSequence)"Skip this goal, cause by \"skipInstall == false && skipDeploy == false\".");
            return;
        }
        if (!"jar".equalsIgnoreCase(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skip this goal, cause by \"packaging != 'jar'\"'.");
            return;
        }
        boolean isSpringBootJar = false;
        List plugins = this.project.getBuildPlugins();
        for (Plugin plugin : plugins) {
            if (!"org.springframework.boot".equalsIgnoreCase(plugin.getGroupId()) || !"spring-boot-maven-plugin".equalsIgnoreCase(plugin.getArtifactId())) continue;
            isSpringBootJar = true;
            break;
        }
        if (isSpringBootJar) {
            this.getLog().info((CharSequence)"The current project is a springboot application, it will not be installed or deployed.");
            if (this.skipInstall) {
                this.project.getProperties().put("maven.install.skip", "true");
                this.getLog().info((CharSequence)"Put properties 'maven.install.skip = true'.");
            }
            if (this.skipDeploy) {
                this.project.getProperties().put("maven.deploy.skip", "true");
                this.getLog().info((CharSequence)"Put properties 'maven.deploy.skip = true'.");
            }
        } else {
            this.getLog().info((CharSequence)"Skip this goal, cause by this project is not a spring-boot application.");
        }
    }
}

