/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo;

import icu.easyj.maven.plugin.mojo.utils.ObjectUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="spring-boot-assist", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class SpringBootAssistantMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="false")
    private boolean skipInstall;
    @Parameter(defaultValue="false")
    private boolean skipDeploy;
    @Parameter
    private String includeGroupIds;

    public void execute() throws MojoExecutionException {
        boolean isSpringBootJar = false;
        if ("jar".equalsIgnoreCase(this.project.getPackaging())) {
            List plugins = this.project.getBuildPlugins();
            for (Plugin plugin : plugins) {
                if (!"org.springframework.boot".equalsIgnoreCase(plugin.getGroupId()) || !"spring-boot-maven-plugin".equalsIgnoreCase(plugin.getArtifactId())) continue;
                isSpringBootJar = true;
                break;
            }
        }
        if (!isSpringBootJar) {
            this.getLog().info((CharSequence)"Skip this goal, cause by this project is not a spring-boot application.");
            return;
        }
        this.getLog().info((CharSequence)"The current project is a springboot application.");
        this.skipInstallAndDeploy();
        this.includeDependencies();
    }

    private void skipInstallAndDeploy() {
        Properties properties = this.project.getProperties();
        if (this.skipInstall && !"true".equalsIgnoreCase(properties.getProperty("maven.install.skip")) || this.skipDeploy && !"true".equalsIgnoreCase(properties.getProperty("maven.deploy.skip"))) {
            this.getLog().info((CharSequence)"It will skip `install` and `deploy`:");
            if (this.skipInstall && !"true".equalsIgnoreCase(properties.getProperty("maven.install.skip"))) {
                properties.put("maven.install.skip", "true");
                this.getLog().info((CharSequence)"  - Put properties 'maven.install.skip = true' for skip `install`.");
            }
            if (this.skipDeploy && !"true".equalsIgnoreCase(properties.getProperty("maven.deploy.skip"))) {
                properties.put("maven.deploy.skip", "true");
                this.getLog().info((CharSequence)"  - Put properties 'maven.deploy.skip = true' for skip `deploy`.");
            }
        }
    }

    private void includeDependencies() {
        if (ObjectUtils.isEmpty(this.includeGroupIds)) {
            return;
        }
        Set<String> includeGroupIds = this.convertIncludeGroupIds(this.includeGroupIds);
        if (includeGroupIds.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("The includeGroupIds: " + includeGroupIds));
        HashSet<String> excludeGroupIds = new HashSet<String>();
        this.project.setArtifactFilter(artifact -> !includeGroupIds.contains(artifact.getGroupId()) && this.isRuntimeScope(artifact.getScope()));
        Set excludeArtifacts = this.project.getArtifacts();
        for (Artifact excludeArtifact : excludeArtifacts) {
            excludeGroupIds.add(excludeArtifact.getGroupId());
        }
        this.project.setArtifactFilter(null);
        if (!excludeGroupIds.isEmpty()) {
            Properties properties = this.project.getProperties();
            String propertyValue = properties.getProperty("spring-boot.excludeGroupIds");
            if (ObjectUtils.isNotEmpty(propertyValue)) {
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)("The origin values of the properties 'spring-boot.excludeGroupIds' for the goal 'spring-boot:repackage':" + propertyValue.trim().replaceAll("^|\\s*,\\s*", "\r\n[INFO]   - ")));
            }
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("Put properties 'spring-boot.excludeGroupIds' to the following values: (" + excludeGroupIds.size() + ")"));
            StringBuilder sb = new StringBuilder();
            for (String excludeGroupId : excludeGroupIds) {
                this.getLog().info((CharSequence)("  - " + excludeGroupId));
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(excludeGroupId);
            }
            properties.put("spring-boot.excludeGroupIds", sb.toString());
            if (!"ZIP".equals(properties.getProperty("spring-boot.repackage.layout"))) {
                properties.put("spring-boot.repackage.layout", "ZIP");
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)"Put properties 'spring-boot.repackage.layout = ZIP' for the goal 'spring-boot:repackage'.");
            }
        } else {
            this.getLog().info((CharSequence)"The 'excludeGroupIds' is empty, do not put the properties 'spring-boot.excludeGroupIds'.");
        }
    }

    private Set<String> convertIncludeGroupIds(String includeGroupIds) {
        String[] includeGroupIdArr;
        HashSet<String> result = new HashSet<String>();
        for (String includeGroupId : includeGroupIdArr = includeGroupIds.split(",")) {
            if ((includeGroupId = includeGroupId.trim()).isEmpty()) continue;
            result.add(includeGroupId);
        }
        return result;
    }

    private boolean isRuntimeScope(String scope) {
        return scope == null || scope.trim().isEmpty() || "compile".equalsIgnoreCase(scope) || "runtime".equalsIgnoreCase(scope);
    }
}

