/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.packagedir;

import icu.easyj.maven.plugin.mojo.utils.ObjectUtils;
import icu.easyj.maven.plugin.mojo.utils.ZipUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="package-zip", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class PackageZipMojo
extends AbstractMojo {
    @Parameter
    private List<String> directories;
    @Parameter
    private String outputFilePathname;

    public void execute() throws MojoExecutionException, MojoFailureException {
        FileOutputStream fos;
        if (ObjectUtils.isEmpty(this.directories)) {
            this.getLog().warn((CharSequence)"directories \u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String directory : this.directories) {
            if (directory == null || directory.trim().isEmpty()) continue;
            files.add(new File(directory.trim()));
        }
        try {
            fos = new FileOutputStream(this.outputFilePathname);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u521b\u5efa\u6587\u4ef6\u6d41\u5931\u8d25", e);
        }
        try {
            ZipUtils.toZip(files, (OutputStream)fos, true);
        }
        catch (IOException e) {
            throw new RuntimeException("\u538b\u7f29\u6587\u4ef6\u6d41\u5931\u8d25", e);
        }
    }
}

