/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.simplify;

import icu.easyj.maven.plugin.mojo.simplify.SimplifyMode;
import icu.easyj.maven.plugin.mojo.simplify.SimplifyPomMojo;
import icu.easyj.maven.plugin.mojo.utils.MatchUtils;
import icu.easyj.maven.plugin.mojo.utils.ObjectUtils;
import java.util.Map;
import org.apache.maven.model.Dependency;

public class SimplifyPomMojoConfig {
    private final SimplifyPomMojo mojo;
    private SimplifyMode mode;

    public SimplifyPomMojoConfig(SimplifyPomMojo mojo) {
        this.mojo = mojo;
    }

    public SimplifyMode getMode() {
        return this.mode;
    }

    public void setMode(SimplifyMode mode) {
        this.mode = mode;
    }

    public Boolean needRemoveParent() {
        return this.mojo.removeParent;
    }

    public boolean isOpenSourceProject() {
        return this.mojo.isOpenSourceProject;
    }

    public boolean isKeepProvidedDependencies() {
        return this.mojo.keepProvidedDependencies;
    }

    public boolean isKeepOptionalDependencies() {
        return this.mojo.keepOptionalDependencies;
    }

    public boolean isKeepTestDependencies() {
        return this.mojo.keepTestDependencies;
    }

    public boolean isExcludeDependency(Dependency dependency) {
        if (ObjectUtils.isEmpty(this.mojo.excludeDependencies)) {
            return false;
        }
        for (String exclude : this.mojo.excludeDependencies) {
            if (!MatchUtils.match(exclude, dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion())) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> getCreateProperties() {
        return this.mojo.createProperties;
    }

    public boolean isExpandImportDependencyManagement() {
        return this.mojo.expandImportDependencyManagement;
    }
}

