/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.skipinstalldeploy;

import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="skip-install-deploy", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class SkipInstallDeployMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="true")
    private boolean skipInstall;
    @Parameter(defaultValue="true")
    private boolean skipDeploy;

    public void execute() throws MojoExecutionException {
        if (!this.skipInstall && !this.skipDeploy) {
            this.getLog().info((CharSequence)"Skip this goal, cause by \"skipInstall == false && skipDeploy == false\".");
            return;
        }
        Properties properties = this.project.getProperties();
        if (this.skipInstall && !"true".equalsIgnoreCase(properties.getProperty("maven.install.skip"))) {
            properties.put("maven.install.skip", "true");
            this.getLog().info((CharSequence)"Put properties 'maven.install.skip = true'.");
        }
        if (this.skipDeploy && !"true".equalsIgnoreCase(properties.getProperty("maven.deploy.skip"))) {
            properties.put("maven.deploy.skip", "true");
            this.getLog().info((CharSequence)"Put properties 'maven.deploy.skip = true'.");
        }
    }
}

