/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class ZipUtils {
    private static final int BUFFER_SIZE = 2048;

    public static void toZip(String srcDir, OutputStream out, boolean keepDirStructure) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(out);){
            File sourceFile = new File(srcDir);
            ZipUtils.compress(sourceFile, zos, sourceFile.getName(), keepDirStructure);
        }
    }

    public static void toZip(List<File> srcFiles, OutputStream out, boolean keepDirStructure) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(out);){
            for (File srcFile : srcFiles) {
                ZipUtils.compress(srcFile, zos, srcFile.getName(), keepDirStructure);
            }
        }
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean keepDirStructure) throws IOException {
        byte[] buf = new byte[2048];
        if (sourceFile.isFile()) {
            zos.putNextEntry(new ZipEntry(name));
            try (FileInputStream in = new FileInputStream(sourceFile);){
                int len;
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
            }
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (keepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (keepDirStructure) {
                        ZipUtils.compress(file, zos, name + "/" + file.getName(), keepDirStructure);
                        continue;
                    }
                    ZipUtils.compress(file, zos, file.getName(), keepDirStructure);
                }
            }
        }
    }
}

