/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.springboot;

import icu.easyj.maven.plugin.mojo.utils.ObjectUtils;
import icu.easyj.maven.plugin.mojo.utils.ZipUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="spring-boot-extend", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class SpringBootExtendMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}")
    private File outputDirectory;
    @Parameter(defaultValue="false")
    private boolean skipInstall;
    @Parameter(defaultValue="false")
    private boolean skipDeploy;
    @Parameter(property="maven.spring-boot-extend.includeGroupIds")
    private String includeGroupIds;
    @Parameter(defaultValue="true")
    private boolean packageExcludedDependenciesToZip;

    public void execute() throws MojoExecutionException {
        boolean isSpringBootJar = false;
        if ("jar".equalsIgnoreCase(this.project.getPackaging())) {
            List plugins = this.project.getBuildPlugins();
            for (Plugin plugin : plugins) {
                if (!"org.springframework.boot".equalsIgnoreCase(plugin.getGroupId()) || !"spring-boot-maven-plugin".equalsIgnoreCase(plugin.getArtifactId())) continue;
                isSpringBootJar = true;
                break;
            }
        }
        if (!isSpringBootJar) {
            this.getLog().info((CharSequence)"Skip this goal, cause by this project is not a spring-boot application.");
            return;
        }
        this.getLog().info((CharSequence)"The current project is a springboot application.");
        this.skipInstallAndDeploy();
        this.includeDependencies();
    }

    private void skipInstallAndDeploy() {
        Properties properties = this.project.getProperties();
        if (this.skipInstall && !"true".equalsIgnoreCase(properties.getProperty("maven.install.skip")) || this.skipDeploy && !"true".equalsIgnoreCase(properties.getProperty("maven.deploy.skip"))) {
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)"It will skip `install` and `deploy`:");
            if (this.skipInstall && !"true".equalsIgnoreCase(properties.getProperty("maven.install.skip"))) {
                properties.put("maven.install.skip", "true");
                this.getLog().info((CharSequence)"  - Put properties 'maven.install.skip = true' for skip `install`.");
            }
            if (this.skipDeploy && !"true".equalsIgnoreCase(properties.getProperty("maven.deploy.skip"))) {
                properties.put("maven.deploy.skip", "true");
                this.getLog().info((CharSequence)"  - Put properties 'maven.deploy.skip = true' for skip `deploy`.");
            }
        }
    }

    private void includeDependencies() {
        if (ObjectUtils.isEmpty(this.includeGroupIds)) {
            return;
        }
        Set<String> includeGroupIds = this.convertIncludeGroupIds(this.includeGroupIds);
        if (includeGroupIds.isEmpty()) {
            return;
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("The includeGroupIds: " + includeGroupIds));
        HashSet<String> excludeGroupIds = new HashSet<String>();
        this.project.setArtifactFilter(artifact -> !includeGroupIds.contains(artifact.getGroupId()) && this.isRuntimeScope(artifact.getScope()));
        Set excludeArtifacts = this.project.getArtifacts();
        for (Artifact excludeArtifact : excludeArtifacts) {
            excludeGroupIds.add(excludeArtifact.getGroupId());
        }
        this.project.setArtifactFilter(null);
        if (!excludeGroupIds.isEmpty()) {
            Properties properties = this.project.getProperties();
            String propertyValue = properties.getProperty("spring-boot.excludeGroupIds");
            if (ObjectUtils.isNotEmpty(propertyValue)) {
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)("The origin values of the property 'spring-boot.excludeGroupIds' for the goal 'spring-boot:repackage':" + propertyValue.trim().replaceAll("^|\\s*,\\s*", "\r\n[INFO]   - ")));
            }
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("Put the following values to the property 'spring-boot.excludeGroupIds' for the goal 'spring-boot:repackage': (" + excludeGroupIds.size() + ")"));
            StringBuilder sb = new StringBuilder();
            for (String excludeGroupId : excludeGroupIds) {
                this.getLog().info((CharSequence)("  - " + excludeGroupId));
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(excludeGroupId);
            }
            properties.put("spring-boot.excludeGroupIds", sb.toString());
            if (!"ZIP".equals(properties.getProperty("spring-boot.repackage.layout"))) {
                properties.put("spring-boot.repackage.layout", "ZIP");
                this.getLog().info((CharSequence)"");
                this.getLog().info((CharSequence)"Put property 'spring-boot.repackage.layout' = 'ZIP' for the goal 'spring-boot:repackage'.");
            }
            if (this.packageExcludedDependenciesToZip) {
                FileOutputStream fos;
                ArrayList<File> excludeLibFiles = new ArrayList<File>(excludeArtifacts.size());
                for (Artifact excludeArtifact : excludeArtifacts) {
                    excludeLibFiles.add(excludeArtifact.getFile());
                }
                try {
                    fos = new FileOutputStream(this.outputDirectory.getPath() + "\\target\\lib.zip");
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException("New FileOutputStream of 'lib.zip' failed.", e);
                }
                try {
                    ZipUtils.toZip(excludeLibFiles, (OutputStream)fos, false, "lib");
                }
                catch (IOException e) {
                    throw new RuntimeException("Package 'lib.zip' failed.", e);
                }
                this.getLog().info((CharSequence)("Package 'lib.zip' success, contains " + excludeLibFiles.size() + " JARs."));
            }
        } else {
            this.getLog().info((CharSequence)"The 'excludeGroupIds' is empty, do not put the property 'spring-boot.excludeGroupIds'.");
        }
    }

    private Set<String> convertIncludeGroupIds(String includeGroupIds) {
        String[] includeGroupIdArr;
        HashSet<String> result = new HashSet<String>();
        for (String includeGroupId : includeGroupIdArr = includeGroupIds.split(",")) {
            if ((includeGroupId = includeGroupId.trim()).isEmpty()) continue;
            result.add(includeGroupId);
        }
        return result;
    }

    private boolean isRuntimeScope(String scope) {
        return scope == null || scope.trim().isEmpty() || "compile".equalsIgnoreCase(scope) || "runtime".equalsIgnoreCase(scope);
    }
}

