/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.packagezip;

import icu.easyj.maven.plugin.mojo.utils.ObjectUtils;
import icu.easyj.maven.plugin.mojo.utils.ZipUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="package-zip", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class PackageZipMojo
extends AbstractMojo {
    @Parameter
    private List<String> paths;
    @Parameter
    private String outputFilePathname;

    public void execute() throws MojoExecutionException, MojoFailureException {
        FileOutputStream fos;
        if (ObjectUtils.isEmpty(this.paths)) {
            this.getLog().warn((CharSequence)"paths \u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (ObjectUtils.isEmpty(this.outputFilePathname)) {
            this.getLog().warn((CharSequence)"outputFile \u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String directory : this.paths) {
            if (directory == null || directory.trim().isEmpty()) continue;
            File file = new File(directory.trim());
            if (file.exists()) {
                files.add(file);
                continue;
            }
            this.getLog().info((CharSequence)("The file is not exists: " + directory));
        }
        if (files.isEmpty()) {
            this.getLog().info((CharSequence)"No file exists, skip this goal.");
            return;
        }
        this.getLog().info((CharSequence)("The files: (" + files.size() + ")"));
        for (File file : files) {
            this.getLog().info((CharSequence)(" - " + file.getPath()));
        }
        try {
            fos = new FileOutputStream(this.outputFilePathname);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("\u521b\u5efa\u6587\u4ef6\u6d41\u5931\u8d25", e);
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("The output file: " + this.outputFilePathname));
        try {
            ZipUtils.toZip(files, (OutputStream)fos, true, null);
        }
        catch (IOException e) {
            throw new RuntimeException("\u538b\u7f29\u6587\u4ef6\u6d41\u5931\u8d25", e);
        }
    }
}

