/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.utils;

import icu.easyj.maven.plugin.mojo.utils.ObjectUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public abstract class ZipUtils {
    private static final int BUFFER_SIZE = 2048;

    public static void toZip(String srcDir, OutputStream out, boolean keepDirStructure, String pathInZip) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(out);){
            File sourceFile = new File(srcDir);
            ZipUtils.compress(sourceFile, zos, sourceFile.getName(), keepDirStructure, ZipUtils.handlePathInZip(pathInZip));
        }
    }

    public static void toZip(List<File> srcFiles, OutputStream out, boolean keepDirStructure, String pathInZip) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(out);){
            for (File srcFile : srcFiles) {
                ZipUtils.compress(srcFile, zos, srcFile.getName(), keepDirStructure, ZipUtils.handlePathInZip(pathInZip));
            }
        }
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name, boolean keepDirStructure, String pathInZip) throws IOException {
        byte[] buf = new byte[2048];
        if (sourceFile.isFile()) {
            ZipEntry zipEntry = new ZipEntry(pathInZip + name);
            zipEntry.setLastModifiedTime(FileTime.fromMillis(sourceFile.lastModified()));
            zos.putNextEntry(zipEntry);
            try (FileInputStream in = new FileInputStream(sourceFile);){
                int len;
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
            }
        } else {
            File[] listFiles = sourceFile.listFiles();
            if (listFiles == null || listFiles.length == 0) {
                if (keepDirStructure) {
                    zos.putNextEntry(new ZipEntry(name + "/"));
                    zos.closeEntry();
                }
            } else {
                for (File file : listFiles) {
                    if (keepDirStructure) {
                        ZipUtils.compress(file, zos, name + "/" + file.getName(), keepDirStructure, null);
                        continue;
                    }
                    ZipUtils.compress(file, zos, file.getName(), keepDirStructure, pathInZip);
                }
            }
        }
    }

    private static String handlePathInZip(String pathInZip) {
        if (ObjectUtils.isEmpty(pathInZip)) {
            return "";
        }
        if (!pathInZip.endsWith("/") && !pathInZip.endsWith("\\")) {
            pathInZip = pathInZip + "\\";
        }
        return pathInZip;
    }
}

