/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.springboot;

import icu.easyj.maven.plugin.mojo.utils.IOUtils;
import icu.easyj.maven.plugin.mojo.utils.MatchUtils;
import icu.easyj.maven.plugin.mojo.utils.ObjectUtils;
import icu.easyj.maven.plugin.mojo.utils.StringUtils;
import icu.easyj.maven.plugin.mojo.utils.ZipUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="spring-boot-extend", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class SpringBootExtendMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}")
    private File outputDirectory;
    @Parameter(defaultValue="false")
    private boolean skipInstall;
    @Parameter(defaultValue="false")
    private boolean skipDeploy;
    @Parameter(property="maven.spring-boot-extend.includeGroupIds")
    private String includeGroupIds;
    @Parameter(property="maven.spring-boot-extend.commonDependencyPatterns")
    private String commonDependencyPatterns;
    @Parameter(property="maven.spring-boot-extend.commonDependencyPatternSet")
    private Set<String> commonDependencyPatternSet;
    @Parameter(property="maven.spring-boot-extend.zipLib", defaultValue="true")
    private boolean zipLib;
    @Parameter(property="maven.spring-boot-extend.needCreateStartupFile", defaultValue="true")
    private boolean needCreateStartupFile;
    @Parameter(property="maven.spring-boot-extend.startupScript", defaultValue="java -jar {loaderPath} {finalName}.jar")
    private String startupScript;

    public void execute() throws MojoExecutionException {
        boolean isSpringBootJar = false;
        String springBootMavenPluginVersion = null;
        if ("jar".equalsIgnoreCase(this.project.getPackaging())) {
            List plugins = this.project.getBuildPlugins();
            for (Plugin plugin : plugins) {
                if (!"org.springframework.boot".equalsIgnoreCase(plugin.getGroupId()) || !"spring-boot-maven-plugin".equalsIgnoreCase(plugin.getArtifactId())) continue;
                isSpringBootJar = true;
                springBootMavenPluginVersion = plugin.getVersion();
                break;
            }
        }
        if (!isSpringBootJar) {
            this.getLog().info((CharSequence)"Skip this goal, cause by this project is not a spring-boot application.");
            return;
        }
        this.getLog().info((CharSequence)"The current project is a springboot application.");
        this.skipInstallAndDeploy();
        String loaderPath = this.includeDependencies(springBootMavenPluginVersion);
        this.createStartupFile(loaderPath);
    }

    private void skipInstallAndDeploy() {
        Properties properties = this.project.getProperties();
        if (this.skipInstall && !"true".equalsIgnoreCase(properties.getProperty("maven.install.skip")) || this.skipDeploy && !"true".equalsIgnoreCase(properties.getProperty("maven.deploy.skip"))) {
            this.emptyLine();
            this.getLog().info((CharSequence)"It will skip `install` and `deploy`:");
            if (this.skipInstall && !"true".equalsIgnoreCase(properties.getProperty("maven.install.skip"))) {
                properties.put("maven.install.skip", "true");
                this.getLog().info((CharSequence)"  - Put property 'maven.install.skip = true' for skip `install`.");
            }
            if (this.skipDeploy && !"true".equalsIgnoreCase(properties.getProperty("maven.deploy.skip"))) {
                properties.put("maven.deploy.skip", "true");
                this.getLog().info((CharSequence)"  - Put property 'maven.deploy.skip = true' for skip `deploy`.");
            }
        }
    }

    private String includeDependencies(String springBootMavenPluginVersion) {
        if (ObjectUtils.isEmpty(this.includeGroupIds)) {
            return null;
        }
        Set<String> includeGroupIds = StringUtils.toTreeSet(this.includeGroupIds);
        if (includeGroupIds.isEmpty()) {
            return null;
        }
        String includeGroupIdsStr = includeGroupIds.toString();
        this.emptyLine();
        this.getLog().info((CharSequence)("The includeGroupIds: " + includeGroupIdsStr.substring(1, includeGroupIdsStr.length() - 1).replaceAll("^|\\s*,\\s*", "\r\n[INFO]   - ")));
        TreeSet<String> excludeGroupIds = new TreeSet<String>(String::compareTo);
        AtomicInteger includeCount = new AtomicInteger(0);
        this.project.setArtifactFilter(artifact -> {
            if (this.isRuntimeArtifact(artifact)) {
                if (!includeGroupIds.contains(artifact.getGroupId())) {
                    return true;
                }
                includeCount.incrementAndGet();
            }
            return false;
        });
        Set excludeArtifacts = this.project.getArtifacts();
        for (Artifact excludeArtifact : excludeArtifacts) {
            excludeGroupIds.add(excludeArtifact.getGroupId());
        }
        this.project.setArtifactFilter(null);
        if (!excludeGroupIds.isEmpty()) {
            Properties properties = this.project.getProperties();
            String propertyValue = properties.getProperty("spring-boot.excludeGroupIds");
            if (ObjectUtils.isNotEmpty(propertyValue)) {
                this.emptyLine();
                this.getLog().info((CharSequence)("The origin values of the property 'spring-boot.excludeGroupIds' for the goal 'spring-boot-maven-plugin:repackage':" + propertyValue.trim().replaceAll("^|\\s*,\\s*", "\r\n[INFO]   - ")));
            }
            this.emptyLine();
            this.getLog().info((CharSequence)("Put the following values to the property 'spring-boot.excludeGroupIds' for the goal 'spring-boot-maven-plugin:repackage': (" + excludeGroupIds.size() + ")"));
            StringBuilder sb = new StringBuilder();
            for (String excludeGroupId : excludeGroupIds) {
                this.getLog().info((CharSequence)("  - " + excludeGroupId));
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(excludeGroupId);
            }
            properties.put("spring-boot.excludeGroupIds", sb.toString());
            if (!"ZIP".equals(properties.getProperty("spring-boot.repackage.layout"))) {
                properties.put("spring-boot.repackage.layout", "ZIP");
                this.emptyLine();
                this.getLog().info((CharSequence)"Put property 'spring-boot.repackage.layout' = 'ZIP' for the goal 'spring-boot-maven-plugin:repackage'.");
                if (springBootMavenPluginVersion.startsWith("0") || springBootMavenPluginVersion.startsWith("1.") || springBootMavenPluginVersion.startsWith("2.0.") || springBootMavenPluginVersion.startsWith("2.1.")) {
                    this.getLog().info((CharSequence)"WARN: The version of the 'spring-boot-maven-plugin' is less than '2.2.0.RELEASE', please set 'layout' to 'ZIP' by yourself.");
                }
            }
            ArrayList<File> jarFiles = new ArrayList<File>();
            ArrayList<File> commonJarFiles = new ArrayList<File>();
            Set<String> commonDependencyPatternSet = StringUtils.toSet(this.commonDependencyPatterns);
            if (ObjectUtils.isNotEmpty(this.commonDependencyPatternSet)) {
                commonDependencyPatternSet.addAll(this.commonDependencyPatternSet);
            }
            if (!commonDependencyPatternSet.isEmpty()) {
                String str = commonDependencyPatternSet.toString();
                this.emptyLine();
                this.getLog().info((CharSequence)("The commonDependencyPatterns: " + str.substring(1, str.length() - 1).replaceAll("^|\\s*,\\s*", "\r\n[INFO]   - ")));
            }
            for (Artifact excludeArtifact : excludeArtifacts) {
                if (this.isCommonJar(excludeArtifact, commonDependencyPatternSet)) {
                    commonJarFiles.add(excludeArtifact.getFile());
                    continue;
                }
                jarFiles.add(excludeArtifact.getFile());
            }
            int total = includeCount.get() + excludeArtifacts.size();
            this.emptyLine();
            this.getLog().info((CharSequence)("  Total: " + total + " JARs"));
            this.getLog().info((CharSequence)("Include: " + StringUtils.padLeft(includeCount.get(), String.valueOf(total).length()) + " JARs"));
            this.getLog().info((CharSequence)("Exclude: " + StringUtils.padLeft(excludeArtifacts.size(), String.valueOf(total).length()) + " JARs\uff08lib: " + jarFiles.size() + ", lib-common: " + commonJarFiles.size() + "\uff09"));
            String loaderPath = "";
            if (this.createLibDirAndZip("lib", jarFiles)) {
                loaderPath = "lib/";
            }
            if (this.createLibDirAndZip("lib-common", commonJarFiles)) {
                if (loaderPath.length() > 0) {
                    loaderPath = loaderPath + ", ";
                }
                loaderPath = loaderPath + "lib-common/";
            }
            return loaderPath;
        }
        this.getLog().info((CharSequence)"The 'excludeGroupIds' is empty, do not put the property 'spring-boot.excludeGroupIds'.");
        return null;
    }

    private boolean createLibDirAndZip(String libDirName, List<File> jarFiles) {
        if (jarFiles.isEmpty()) {
            return false;
        }
        this.emptyLine();
        File libDir = new File(this.outputDirectory.getPath() + "\\target\\" + libDirName);
        if (!libDir.exists()) {
            this.getLog().info((CharSequence)("Create directory: " + libDir.getPath()));
            if (!libDir.mkdir()) {
                throw new RuntimeException("Create directory failed: " + libDir.getPath());
            }
        }
        this.getLog().info((CharSequence)("Copy " + jarFiles.size() + " JARs to the directory: " + libDir.getPath()));
        for (File jarFile : jarFiles) {
            try {
                IOUtils.copy(jarFile, new File(libDir, jarFile.getName()));
            }
            catch (IOException e) {
                throw new RuntimeException("Copy '" + jarFile.getName() + "' to the directory '" + libDir.getPath() + "' failed.", e);
            }
        }
        if (this.zipLib) {
            FileOutputStream fos;
            try {
                fos = new FileOutputStream(this.outputDirectory.getPath() + "\\target\\" + libDirName + "---" + jarFiles.size() + "-JARs.zip");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("New FileOutputStream of '" + libDirName + ".zip' failed.", e);
            }
            try {
                ZipUtils.toZip(jarFiles, (OutputStream)fos, false, libDirName);
            }
            catch (IOException e) {
                throw new RuntimeException("Package '" + libDirName + ".zip' failed.", e);
            }
            this.getLog().info((CharSequence)("Package '" + libDirName + ".zip' succeeded, contains " + jarFiles.size() + " JARs."));
        }
        return true;
    }

    private void createStartupFile(String loaderPath) {
        if (!this.needCreateStartupFile) {
            return;
        }
        this.emptyLine();
        String startupScript = this.startupScript.replaceAll("\\s*\\{\\s*loaderPath\\s*\\}", ObjectUtils.isNotEmpty(loaderPath) ? " -Dloader.path=\"" + loaderPath + "\"" : "").replaceAll("\\s*\\{\\s*(finalName)\\s*\\}", " " + this.project.getBuild().getFinalName()).replaceAll("\\s*\\{\\s*(artifactId)\\s*\\}", " " + this.project.getArtifactId());
        this.createStartupFile("bat", startupScript + "\r\ncmd");
        this.createStartupFile("sh", "#!/bin/sh\r\n" + startupScript + "\r\n");
    }

    private void createStartupFile(String fileSuffix, String startupScriptText) {
        File file = new File(this.outputDirectory.getPath() + "\\target\\startup." + fileSuffix);
        try {
            IOUtils.createFile(file, startupScriptText);
            this.getLog().info((CharSequence)("Create startup file succeeded: " + file.getName()));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Create startup file failed: " + file.getName()), (Throwable)e);
        }
    }

    private boolean isCommonJar(Artifact artifact, Set<String> commonDependencyPatternSet) {
        for (String commonArtifactPattern : commonDependencyPatternSet) {
            if (!MatchUtils.match(commonArtifactPattern, artifact.getGroupId() + ":" + artifact.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private boolean isRuntimeArtifact(Artifact artifact) {
        if (artifact.isOptional()) {
            return false;
        }
        String scope = artifact.getScope();
        return scope == null || scope.trim().isEmpty() || "compile".equalsIgnoreCase(scope) || "runtime".equalsIgnoreCase(scope);
    }

    private void emptyLine() {
        this.getLog().info((CharSequence)"");
    }
}

