/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;

public abstract class StringUtils {
    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static String padLeft(Object obj, int length) {
        String str = obj.toString();
        if (str.length() >= length) {
            return str;
        }
        StringBuilder sb = new StringBuilder(length);
        length -= str.length();
        while (length-- > 0) {
            sb.append(" ");
        }
        sb.append(str);
        return sb.toString();
    }

    public static Set<String> addToSet(Set<String> set, String str) {
        assert (set != null);
        if (str != null) {
            while (str.startsWith("\"")) {
                str = str.substring(1);
            }
            while (str.endsWith("\"")) {
                str = str.substring(0, str.length() - 1);
            }
        }
        if (StringUtils.isNotEmpty(str)) {
            String[] strArr;
            for (String s : strArr = str.split(",")) {
                if ((s = s.trim()).isEmpty()) continue;
                set.add(s);
            }
        }
        return set;
    }

    @Nonnull
    public static Set<String> toSet(String str) {
        HashSet<String> result = new HashSet<String>();
        return StringUtils.addToSet(result, str);
    }

    @Nonnull
    public static Set<String> toTreeSet(String str) {
        TreeSet<String> result = new TreeSet<String>(String::compareTo);
        return StringUtils.addToSet(result, str);
    }
}

