/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.springboot;

import java.io.File;
import java.util.List;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractSpringBootMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.basedir}")
    protected File outputDirectory;
    protected String springBootMavenPluginVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isSpringBootApplication()) {
            this.getLog().info((CharSequence)"Skip this goal, cause by this project is not a spring-boot application.");
            return;
        }
        this.doExecute();
    }

    abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    private boolean isSpringBootApplication() {
        if ("jar".equalsIgnoreCase(this.project.getPackaging())) {
            List plugins = this.project.getBuildPlugins();
            for (Plugin plugin : plugins) {
                if (!"org.springframework.boot".equalsIgnoreCase(plugin.getGroupId()) || !"spring-boot-maven-plugin".equalsIgnoreCase(plugin.getArtifactId())) continue;
                this.springBootMavenPluginVersion = plugin.getVersion();
                return true;
            }
        }
        return false;
    }

    protected void emptyLine() {
        this.getLog().info((CharSequence)"");
    }
}

