/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.springboot;

import icu.easyj.maven.plugin.mojo.springboot.AbstractSpringBootMojo;
import icu.easyj.maven.plugin.mojo.utils.IOUtils;
import icu.easyj.maven.plugin.mojo.utils.MatchUtils;
import icu.easyj.maven.plugin.mojo.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="spring-boot-release", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class SpringBootReleaseMojo
extends AbstractSpringBootMojo {
    @Parameter(property="maven.spring-boot-release.filePatterns")
    private Set<String> filePatterns;
    @Parameter(property="maven.spring-boot-release.dir")
    private String releaseDirectory;

    @Override
    public void doExecute() throws MojoExecutionException {
        if (StringUtils.isEmpty(this.releaseDirectory)) {
            throw new RuntimeException("releasePath\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String releaseDirectory = this.releaseDirectory.trim().replaceAll("\\s*\\{\\s*(finalName)\\s*\\}", this.project.getBuild().getFinalName()).replaceAll("\\s*\\{\\s*(artifactId)\\s*\\}", this.project.getArtifactId()).replaceAll("[:\\*\\?\\\"'\\<\\>\\|]+", "");
        this.getLog().info((CharSequence)("The release directory: " + releaseDirectory));
        File releaseDir = new File(releaseDirectory);
        if (!releaseDir.exists() && !releaseDir.mkdirs()) {
            this.getLog().warn((CharSequence)("\u521b\u5efa\u53d1\u5e03\u6587\u4ef6\u5939\u5931\u8d25\uff1a" + releaseDir.getPath()));
            return;
        }
        File targetDir = new File(this.outputDirectory + "\\target\\");
        if (!targetDir.exists()) {
            throw new RuntimeException("target\u6587\u4ef6\u5939\u4e0d\u5b58\u5728");
        }
        if (!targetDir.isDirectory()) {
            throw new RuntimeException(targetDir.getPath() + "\u4e0d\u662f\u6587\u4ef6\u5939");
        }
        HashSet<String> patterns = new HashSet<String>();
        for (String filePattern : this.filePatterns) {
            if (StringUtils.isEmpty(filePattern)) continue;
            patterns.add(filePattern.trim().replaceAll("\\s*\\{\\s*(finalName)\\s*\\}", this.project.getBuild().getFinalName()).replaceAll("\\s*\\{\\s*(artifactId)\\s*\\}", this.project.getArtifactId()));
        }
        this.getLog().info((CharSequence)("The file patterns: " + patterns));
        File[] files = targetDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !MatchUtils.match(patterns, file.getName())) continue;
                File copyFile = new File(releaseDir, file.getName());
                try {
                    IOUtils.copy(file, copyFile);
                    this.getLog().info((CharSequence)("Copy file '/target/" + file.getName() + "' to '" + copyFile.getPath() + "'."));
                }
                catch (IOException e) {
                    this.getLog().warn((CharSequence)("Copy file failed\uff1a" + file.getPath() + " -> " + copyFile.getPath()), (Throwable)e);
                }
            }
        }
    }
}

