/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.packagezip;

import icu.easyj.maven.plugin.mojo.utils.ObjectUtils;
import icu.easyj.maven.plugin.mojo.utils.ZipUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="package-zip", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class PackageZipMojo
extends AbstractMojo {
    @Parameter
    private List<String> paths;
    @Parameter
    private String outputFilePathname;

    public void execute() throws MojoExecutionException {
        FileOutputStream fos;
        if (ObjectUtils.isEmpty(this.paths)) {
            this.getLog().warn((CharSequence)"'paths' must not be empty.");
            return;
        }
        if (ObjectUtils.isEmpty(this.outputFilePathname)) {
            this.getLog().warn((CharSequence)"'outputFilePathname' must not be empty.");
            return;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String directory : this.paths) {
            if (directory == null || directory.trim().isEmpty()) continue;
            File file = new File(directory.trim());
            if (file.exists()) {
                files.add(file);
                continue;
            }
            this.getLog().info((CharSequence)("The file is not exists: " + directory));
        }
        if (files.isEmpty()) {
            this.getLog().info((CharSequence)"No file exists, skip this goal.");
            return;
        }
        this.getLog().info((CharSequence)("The files: (" + files.size() + ")"));
        for (File file : files) {
            this.getLog().info((CharSequence)(" - " + file.getPath()));
        }
        try {
            fos = new FileOutputStream(this.outputFilePathname);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Create 'fos' failed", e);
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("The output file: " + this.outputFilePathname));
        try {
            ZipUtils.toZip(files, (OutputStream)fos, true, null);
        }
        catch (IOException e) {
            throw new RuntimeException("Zip files failed", e);
        }
    }
}

