/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.springboot;

import icu.easyj.maven.plugin.mojo.springboot.AbstractSpringBootMojo;
import icu.easyj.maven.plugin.mojo.utils.IOUtils;
import icu.easyj.maven.plugin.mojo.utils.MatchUtils;
import icu.easyj.maven.plugin.mojo.utils.ObjectUtils;
import icu.easyj.maven.plugin.mojo.utils.StringUtils;
import icu.easyj.maven.plugin.mojo.utils.ZipUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="spring-boot-extend", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class SpringBootExtendMojo
extends AbstractSpringBootMojo {
    @Parameter(defaultValue="false")
    private boolean skipInstall;
    @Parameter(defaultValue="false")
    private boolean skipDeploy;
    @Parameter(property="maven.spring-boot-extend.includeGroupIds")
    private String includeGroupIds;
    @Parameter(property="maven.spring-boot-extend.additionalIncludeGroupIds")
    private String additionalIncludeGroupIds;
    @Parameter(property="maven.spring-boot-extend.commonDependencyPatterns")
    private String commonDependencyPatterns;
    @Parameter(property="maven.spring-boot-extend.commonDependencyPatternSet")
    private Set<String> commonDependencyPatternSet;
    @Parameter(property="maven.spring-boot-extend.zipLib", defaultValue="true")
    private boolean zipLib;
    @Parameter(property="maven.spring-boot-extend.needCreateStartupFile", defaultValue="true")
    private boolean needCreateStartupFile;
    @Parameter(property="maven.spring-boot-extend.startupScript", defaultValue="java -jar ^ {loaderPath} ^ {finalName}.jar")
    private String startupScript;

    @Override
    public void doExecute() throws MojoExecutionException {
        this.info("The current project is a springboot application.");
        this.skipInstallAndDeploy();
        String loaderPath = this.includeDependencies();
        this.createStartupFile(loaderPath);
    }

    private void skipInstallAndDeploy() {
        Properties properties = this.project.getProperties();
        if (this.skipInstall && !"true".equalsIgnoreCase(properties.getProperty("maven.install.skip")) || this.skipDeploy && !"true".equalsIgnoreCase(properties.getProperty("maven.deploy.skip"))) {
            this.emptyLine();
            this.info("It will skip `install` and `deploy`:");
            if (this.skipInstall && !"true".equalsIgnoreCase(properties.getProperty("maven.install.skip"))) {
                properties.put("maven.install.skip", "true");
                this.info("  > Put property 'maven.install.skip = true' for skip `install`.");
            }
            if (this.skipDeploy && !"true".equalsIgnoreCase(properties.getProperty("maven.deploy.skip"))) {
                properties.put("maven.deploy.skip", "true");
                this.info("  > Put property 'maven.deploy.skip = true' for skip `deploy`.");
            }
        }
    }

    private String includeDependencies() {
        Set<String> includeGroupIds = this.getIncludeGroupIds();
        if (ObjectUtils.isEmpty(includeGroupIds)) {
            return null;
        }
        this.emptyLine();
        this.info("The includeGroupIds: " + this.collectionToStr(includeGroupIds));
        TreeSet<String> excludeGroupIds = new TreeSet<String>(String::compareTo);
        AtomicInteger includeCount = new AtomicInteger(0);
        this.project.setArtifactFilter(artifact -> {
            if (this.isRuntimeArtifact(artifact)) {
                if (!includeGroupIds.contains(artifact.getGroupId())) {
                    return true;
                }
                includeCount.incrementAndGet();
            }
            return false;
        });
        Set excludeArtifacts = this.project.getArtifacts();
        for (Artifact excludeArtifact : excludeArtifacts) {
            excludeGroupIds.add(excludeArtifact.getGroupId());
        }
        this.project.setArtifactFilter(null);
        if (excludeGroupIds.isEmpty()) {
            this.info("The 'excludeGroupIds' is empty, do not put the property 'spring-boot.excludeGroupIds'.");
            return null;
        }
        Properties properties = this.project.getProperties();
        String propertyValue = this.getProperty("spring-boot.excludeGroupIds");
        if (ObjectUtils.isNotEmpty(propertyValue)) {
            this.emptyLine();
            this.info("The origin values of the property 'spring-boot.excludeGroupIds' for the goal 'spring-boot-maven-plugin:repackage':" + this.handleListStr(propertyValue.trim()));
        }
        this.emptyLine();
        this.info("Put the following values to the property 'spring-boot.excludeGroupIds' for the goal 'spring-boot-maven-plugin:repackage': (%d)%s", excludeGroupIds.size(), this.collectionToStr(excludeGroupIds));
        properties.put("spring-boot.excludeGroupIds", StringUtils.toString(excludeGroupIds));
        if (!this.containsProperty("spring-boot.repackage.layout", "ZIP")) {
            properties.put("spring-boot.repackage.layout", "ZIP");
            this.emptyLine();
            this.info("Put property 'spring-boot.repackage.layout' = 'ZIP' for the goal 'spring-boot-maven-plugin:repackage'.");
            if (this.springBootMavenPluginVersion.startsWith("0") || this.springBootMavenPluginVersion.startsWith("1.") || this.springBootMavenPluginVersion.startsWith("2.0.") || this.springBootMavenPluginVersion.startsWith("2.1.")) {
                this.info("WARN: The version of the 'spring-boot-maven-plugin' is less than '2.2.0.RELEASE', please set 'layout' to 'ZIP' by yourself.");
            }
        }
        ArrayList<File> jarFiles = new ArrayList<File>();
        ArrayList<File> commonJarFiles = new ArrayList<File>();
        Set<String> commonDependencyPatternSet = StringUtils.toSet(this.commonDependencyPatterns);
        if (ObjectUtils.isNotEmpty(this.commonDependencyPatternSet)) {
            commonDependencyPatternSet.addAll(this.commonDependencyPatternSet);
        }
        if (!commonDependencyPatternSet.isEmpty()) {
            this.emptyLine();
            this.info("The commonDependencyPatterns: " + this.collectionToStr(commonDependencyPatternSet));
        }
        for (Artifact excludeArtifact : excludeArtifacts) {
            if (this.isCommonJar(excludeArtifact, commonDependencyPatternSet)) {
                commonJarFiles.add(excludeArtifact.getFile());
                continue;
            }
            jarFiles.add(excludeArtifact.getFile());
        }
        int total = includeCount.get() + excludeArtifacts.size();
        this.emptyLine();
        this.info("  Total: %d JARs", total);
        this.info("Include: %s JARs", StringUtils.padLeft(includeCount.get(), String.valueOf(total).length()));
        this.info("Exclude: %s JARs\uff08lib: %d, lib-common: %d\uff09", StringUtils.padLeft(excludeArtifacts.size(), String.valueOf(total).length()), jarFiles.size(), commonJarFiles.size());
        String loaderPath = "";
        if (this.createLibDirAndZip("lib", jarFiles)) {
            loaderPath = "lib/";
        }
        if (this.createLibDirAndZip("lib-common", commonJarFiles)) {
            if (loaderPath.length() > 0) {
                loaderPath = loaderPath + ", ";
            }
            loaderPath = loaderPath + "lib-common/";
        }
        return loaderPath;
    }

    @Nullable
    private Set<String> getIncludeGroupIds() {
        String includeGroupIdsStr = this.includeGroupIds;
        if (ObjectUtils.isEmpty(includeGroupIdsStr)) {
            return null;
        }
        if (ObjectUtils.isNotEmpty(this.additionalIncludeGroupIds)) {
            includeGroupIdsStr = includeGroupIdsStr + "," + this.additionalIncludeGroupIds;
        }
        return StringUtils.toTreeSet(includeGroupIdsStr);
    }

    private boolean createLibDirAndZip(String libDirName, List<File> jarFiles) {
        if (jarFiles.isEmpty()) {
            return false;
        }
        File libDir = this.createLibDir(libDirName);
        this.emptyLine();
        this.info("Copy %d JARs to the directory: %s", jarFiles.size(), libDir.getPath());
        this.copyFilesToDir(jarFiles, libDir);
        if (this.zipLib) {
            FileOutputStream fos;
            try {
                fos = new FileOutputStream(this.outputDirectory.getPath() + "\\target\\" + libDirName + "---" + jarFiles.size() + "-JARs.zip");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("New FileOutputStream of '" + libDirName + ".zip' failed.", e);
            }
            try {
                ZipUtils.toZip(jarFiles, (OutputStream)fos, false, libDirName);
            }
            catch (IOException e) {
                throw new RuntimeException("Package '" + libDirName + ".zip' failed.", e);
            }
            this.info("Package '%s.zip' succeeded, contains %d JARs.", libDirName, jarFiles.size());
        }
        return true;
    }

    private boolean isCommonJar(Artifact artifact, Set<String> commonDependencyPatternSet) {
        for (String commonArtifactPattern : commonDependencyPatternSet) {
            if (!MatchUtils.match(commonArtifactPattern, artifact.getGroupId() + ":" + artifact.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private void createStartupFile(String loaderPath) {
        if (!this.needCreateStartupFile) {
            return;
        }
        this.emptyLine();
        String startupScript = this.replacePlaceholder(this.startupScript).replaceAll("\\s*\\{\\s*loaderPath\\s*\\}", ObjectUtils.isNotEmpty(loaderPath) ? " -Dloader.path=\"" + loaderPath + "\" ^" : "").replaceAll("\\s*(\\^|\\<br\\s*\\/\\>)(\\s|\\^|\\<br\\s*\\/\\>)*", " ^\r\n     ");
        this.createStartupFile("bat", startupScript + "\r\n\r\ncmd\r\n");
        this.createStartupFile("sh", "#!/bin/sh\r\n\r\n" + startupScript.replace('^', '\\') + "\r\n");
    }

    private void createStartupFile(String fileSuffix, String startupScriptText) {
        File file = new File(this.outputDirectory.getPath() + "\\target\\startup." + fileSuffix);
        try {
            IOUtils.createFile(file, startupScriptText);
            this.info("Create startup file succeeded: %s, the startup script:\r\n===>\r\n%s\r\n<===\r\n", file.getName(), startupScriptText.trim());
        }
        catch (IOException e) {
            this.error("Create startup file failed: %s", file.getName(), e);
        }
    }
}

