/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class IOUtils {
    public static final String LINE_SEPARATOR = "\n";

    public static void copy(File sourceFile, File targetFile) throws IOException {
        try (FileInputStream in = new FileInputStream(sourceFile);
             FileOutputStream out = new FileOutputStream(targetFile);){
            byte[] buffer = new byte[in.available()];
            in.read(buffer);
            out.write(buffer);
            out.flush();
        }
        try {
            targetFile.setLastModified(IOUtils.getFileLastModified(sourceFile));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void createFile(File newFile, String text) throws IOException {
        try (FileOutputStream out = new FileOutputStream(newFile);){
            out.write(text.getBytes());
            out.flush();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getFileLastModified(File file) {
        if (!file.getName().endsWith(".jar")) return file.lastModified();
        try (JarFile jarFile = new JarFile(file);){
            JarEntry jarEntry = jarFile.getJarEntry("META-INF/MANIFEST.MF");
            if (jarEntry == null) return file.lastModified();
            long l = jarEntry.getTime();
            return l;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.lastModified();
    }
}

