/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Nullable;

public abstract class IOUtils {
    public static final String LINE_SEPARATOR = "\n";
    public static final String LINE_SEPARATOR2 = "\r\n";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getFileTxt(File file) {
        try (Scanner sc = new Scanner(file);){
            StringBuilder sb = new StringBuilder();
            while (sc.hasNextLine()) {
                sb.append(sc.nextLine()).append(LINE_SEPARATOR);
            }
            String string = sb.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static String getInputStreamTxt(InputStream is) {
        try (Scanner sc = new Scanner(is);){
            StringBuilder sb = new StringBuilder();
            while (sc.hasNextLine()) {
                if (sb.length() > 0) {
                    sb.append(LINE_SEPARATOR);
                }
                sb.append(sc.nextLine());
            }
            String string = sb.toString();
            return string;
        }
    }

    public static void copy(File sourceFile, File targetFile) throws IOException {
        try (FileInputStream in = new FileInputStream(sourceFile);
             FileOutputStream out = new FileOutputStream(targetFile);){
            byte[] buffer = new byte[in.available()];
            in.read(buffer);
            out.write(buffer);
            out.flush();
        }
        try {
            targetFile.setLastModified(IOUtils.getFileLastModified(sourceFile));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public static void createFile(File newFile, String text) throws IOException {
        try (FileOutputStream out = new FileOutputStream(newFile);){
            out.write(text.getBytes());
            out.flush();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getFileLastModified(File file) {
        if (!file.getName().endsWith(".jar")) return file.lastModified();
        try (JarFile jarFile = new JarFile(file);){
            JarEntry jarEntry = jarFile.getJarEntry("META-INF/MANIFEST.MF");
            if (jarEntry == null) return file.lastModified();
            long l = jarEntry.getTime();
            return l;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.lastModified();
    }
}

