/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.springboot;

import icu.easyj.maven.plugin.mojo.springboot.AbstractSpringBootMojo;
import icu.easyj.maven.plugin.mojo.utils.IOUtils;
import icu.easyj.maven.plugin.mojo.utils.MatchUtils;
import icu.easyj.maven.plugin.mojo.utils.ObjectUtils;
import icu.easyj.maven.plugin.mojo.utils.StringUtils;
import icu.easyj.maven.plugin.mojo.utils.ZipUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="spring-boot-extend", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class SpringBootExtendMojo
extends AbstractSpringBootMojo {
    private static final String SEPARATOR = " | ";
    @Parameter(defaultValue="false")
    private boolean skipInstall;
    @Parameter(defaultValue="false")
    private boolean skipDeploy;
    @Parameter(property="maven.spring-boot-extend.includeGroupIds")
    private String includeGroupIds;
    @Parameter(property="maven.spring-boot-extend.additionalIncludeGroupIds")
    private String additionalIncludeGroupIds;
    @Parameter(property="maven.spring-boot-extend.commonDependencyPatterns")
    private String commonDependencyPatterns;
    @Parameter(property="maven.spring-boot-extend.commonDependencyPatternSet")
    private Set<String> commonDependencyPatternSet;
    @Parameter(property="maven.spring-boot-extend.zipLib", defaultValue="true")
    private boolean zipLib;
    @Parameter(property="maven.spring-boot-extend.createLibHistory", defaultValue="true")
    private boolean createLibHistory;
    @Parameter(property="maven.spring-boot-extend.needCreateStartupFile", defaultValue="true")
    private boolean needCreateStartupFile;
    @Parameter(property="maven.spring-boot-extend.startupScript", defaultValue="java -Xms64m -Xmx128m ^\r\n     -jar ^\r\n     {loaderPath} ^\r\n     -Dspring.profiles.active={activeProfile} ^\r\n     -Dspring.config.location=application.yml ^\r\n     -Dspring.config.additional-location=application-{activeProfile}.yml ^\r\n     {startupScriptAdditionalParameter} ^\r\n     {finalName}.jar")
    private String startupScript;
    @Parameter(property="maven.spring-boot-extend.startupScriptAdditionalParameter")
    private String startupScriptAdditionalParameter;
    @Parameter(property="maven.spring-boot-extend.activeProfile", defaultValue="prod")
    private String activeProfile;

    @Override
    public void doExecute() throws MojoExecutionException, IOException {
        this.info("The current project is a springboot application.");
        this.skipInstallAndDeploy();
        String loaderPath = this.includeDependencies();
        this.createStartupFile(loaderPath);
    }

    private void skipInstallAndDeploy() {
        Properties properties = this.project.getProperties();
        if (this.skipInstall && !"true".equalsIgnoreCase(properties.getProperty("maven.install.skip")) || this.skipDeploy && !"true".equalsIgnoreCase(properties.getProperty("maven.deploy.skip"))) {
            this.emptyLine();
            this.info("It will skip `install` and `deploy`:");
            if (this.skipInstall && !"true".equalsIgnoreCase(properties.getProperty("maven.install.skip"))) {
                properties.put("maven.install.skip", "true");
                this.info("  > Put property 'maven.install.skip = true' for skip `install`.");
            }
            if (this.skipDeploy && !"true".equalsIgnoreCase(properties.getProperty("maven.deploy.skip"))) {
                properties.put("maven.deploy.skip", "true");
                this.info("  > Put property 'maven.deploy.skip = true' for skip `deploy`.");
            }
        }
    }

    private String includeDependencies() throws IOException {
        Set<String> includeGroupIds = this.getIncludeGroupIds();
        if (ObjectUtils.isEmpty(includeGroupIds)) {
            return null;
        }
        this.emptyLine();
        this.info("The includeGroupIds: " + this.collectionToStr(includeGroupIds));
        TreeSet<String> excludeGroupIds = new TreeSet<String>(String::compareTo);
        AtomicInteger includeCount = new AtomicInteger(0);
        this.project.setArtifactFilter(artifact -> {
            if (this.isRuntimeArtifact(artifact)) {
                if (!includeGroupIds.contains(artifact.getGroupId())) {
                    return true;
                }
                includeCount.incrementAndGet();
            }
            return false;
        });
        Set excludeArtifacts = this.project.getArtifacts();
        for (Artifact excludeArtifact : excludeArtifacts) {
            excludeGroupIds.add(excludeArtifact.getGroupId());
        }
        this.project.setArtifactFilter(null);
        if (excludeGroupIds.isEmpty()) {
            this.info("The 'excludeGroupIds' is empty, do not put the property 'spring-boot.excludeGroupIds'.");
            return null;
        }
        Properties properties = this.project.getProperties();
        String propertyValue = this.getProperty("spring-boot.excludeGroupIds");
        if (ObjectUtils.isNotEmpty(propertyValue)) {
            this.emptyLine();
            this.info("The origin values of the property 'spring-boot.excludeGroupIds' for the goal 'spring-boot-maven-plugin:repackage':" + this.handleListStr(propertyValue.trim()));
        }
        this.emptyLine();
        this.info("Put the following values to the property 'spring-boot.excludeGroupIds' for the goal 'spring-boot-maven-plugin:repackage': (%d)%s", excludeGroupIds.size(), this.collectionToStr(excludeGroupIds));
        properties.put("spring-boot.excludeGroupIds", StringUtils.toString(excludeGroupIds));
        if (!this.containsProperty("spring-boot.repackage.layout", "ZIP")) {
            properties.put("spring-boot.repackage.layout", "ZIP");
            this.emptyLine();
            this.info("Put property 'spring-boot.repackage.layout' = 'ZIP' for the goal 'spring-boot-maven-plugin:repackage'.");
            if (this.springBootMavenPluginVersion.startsWith("0") || this.springBootMavenPluginVersion.startsWith("1.") || this.springBootMavenPluginVersion.startsWith("2.0.") || this.springBootMavenPluginVersion.startsWith("2.1.")) {
                this.info("WARN: The version of the 'spring-boot-maven-plugin' is less than '2.2.0.RELEASE', please set 'layout' to 'ZIP' by yourself.");
            }
        }
        ArrayList<Artifact> jarArtifacts = new ArrayList<Artifact>();
        ArrayList<Artifact> commonJarArtifacts = new ArrayList<Artifact>();
        Set<String> commonDependencyPatternSet = StringUtils.toSet(this.commonDependencyPatterns);
        if (ObjectUtils.isNotEmpty(this.commonDependencyPatternSet)) {
            commonDependencyPatternSet.addAll(this.commonDependencyPatternSet);
        }
        if (!commonDependencyPatternSet.isEmpty()) {
            this.emptyLine();
            this.info("The commonDependencyPatterns: " + this.collectionToStr(commonDependencyPatternSet));
        }
        for (Artifact excludeArtifact : excludeArtifacts) {
            if (this.isCommonJar(excludeArtifact, commonDependencyPatternSet)) {
                commonJarArtifacts.add(excludeArtifact);
                continue;
            }
            jarArtifacts.add(excludeArtifact);
        }
        int total = includeCount.get() + excludeArtifacts.size();
        this.emptyLine();
        this.info("  Total: %d JARs", total);
        this.info("Include: %s JARs", StringUtils.padLeft(includeCount.get(), String.valueOf(total).length()));
        this.info("Exclude: %s JARs\uff08lib: %d, lib-common: %d\uff09", StringUtils.padLeft(excludeArtifacts.size(), String.valueOf(total).length()), jarArtifacts.size(), commonJarArtifacts.size());
        String loaderPath = "";
        if (this.createLibDirAndZip("lib", jarArtifacts)) {
            loaderPath = "lib/";
        }
        if (this.createLibDirAndZip("lib-common", commonJarArtifacts)) {
            if (loaderPath.length() > 0) {
                loaderPath = loaderPath + ", ";
            }
            loaderPath = loaderPath + "lib-common/";
        }
        return loaderPath;
    }

    @Nullable
    private Set<String> getIncludeGroupIds() {
        String includeGroupIdsStr = this.includeGroupIds;
        if (ObjectUtils.isEmpty(includeGroupIdsStr)) {
            return null;
        }
        if (ObjectUtils.isNotEmpty(this.additionalIncludeGroupIds)) {
            includeGroupIdsStr = includeGroupIdsStr + "," + this.additionalIncludeGroupIds;
        }
        return StringUtils.toTreeSet(includeGroupIdsStr);
    }

    private boolean createLibDirAndZip(String libDirName, List<Artifact> jarArtifacts) throws IOException {
        if (jarArtifacts.isEmpty()) {
            return false;
        }
        File libDir = this.createLibDir(libDirName);
        this.emptyLine();
        this.info("Copy %d JARs to the directory: %s", jarArtifacts.size(), libDir.getPath());
        this.copyFilesToDir2(jarArtifacts, libDir);
        if (this.createLibHistory) {
            this.createLibHistoryFile(libDirName, jarArtifacts);
        }
        if (this.zipLib) {
            FileOutputStream fos;
            try {
                fos = new FileOutputStream(this.outputDirectory.getPath() + "\\target\\" + libDirName + "---" + jarArtifacts.size() + "-JARs.zip");
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("New FileOutputStream of '" + libDirName + ".zip' failed.", e);
            }
            try {
                ZipUtils.toZip3(jarArtifacts, fos, false, libDirName);
            }
            catch (IOException e) {
                throw new RuntimeException("Package '" + libDirName + ".zip' failed.", e);
            }
            this.info("Package '%s.zip' succeeded, contains %d JARs.", libDirName, jarArtifacts.size());
        }
        return true;
    }

    private void createLibHistoryFile(String libDirName, List<Artifact> jarArtifacts) throws IOException {
        jarArtifacts.sort(Comparator.comparing(a -> a.getFile().getName().toLowerCase()));
        int maxNameLength = 0;
        int maxGroupIdLength = 0;
        int maxBLength = 0;
        int maxKBLength = 0;
        long totalLength = 0L;
        for (Artifact artifact : jarArtifacts) {
            File jarFile = artifact.getFile();
            if (maxNameLength < jarFile.getName().length()) {
                maxNameLength = jarFile.getName().length();
            }
            if (maxGroupIdLength < artifact.getGroupId().length()) {
                maxGroupIdLength = artifact.getGroupId().length();
            }
            if (maxBLength < String.valueOf(jarFile.length()).length()) {
                maxBLength = String.valueOf(jarFile.length()).length();
            }
            if (maxKBLength < String.valueOf(jarFile.length() / 1024L).length()) {
                maxKBLength = String.valueOf(jarFile.length() / 1024L).length();
            }
            totalLength += jarFile.length();
        }
        maxNameLength = Math.max(maxNameLength, 9);
        maxGroupIdLength = Math.max(maxGroupIdLength, 8);
        maxBLength = Math.max(maxBLength, 5);
        maxKBLength = Math.max(maxKBLength, 5);
        StringBuilder history = new StringBuilder();
        history.append("```yaml").append("\n").append("Created-By: icu.easyj.maven.plugins:easyj-maven-plugin:1.0.8(goal:spring-boot-extend)").append("\n").append("Created-On: ").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(System.currentTimeMillis())).append("\n").append("Tips: Please push this file to the VCS(Version Control System), it can be used to compare future changes to libs.").append("\n").append("```").append("\n").append("\n");
        history.append("```yaml").append("\n").append("groupId: ").append(this.project.getGroupId()).append("\n").append("artifactId: ").append(this.project.getArtifactId()).append("\n").append("version: ").append(this.project.getVersion()).append("\n").append("```").append("\n").append("\n");
        history.append("```yaml").append("\n");
        history.append("Number of libs: ").append(jarArtifacts.size()).append("\n");
        history.append("Size of libs: ").append(totalLength).append(" B | ").append(totalLength / 1024L).append(" KB | ").append(totalLength / 1024L / 1024L).append(" MB").append("\n");
        history.append("```").append("\n").append("\n");
        history.append("| File Name").append(this.buildStr(maxNameLength - 9, ' ')).append(" ").append("| Group ID").append(this.buildStr(maxGroupIdLength - 8, ' ')).append(" ").append("|        Time         ").append("| ").append(this.buildStr(maxBLength - 5, ' ')).append("Size(B) ").append("| ").append(this.buildStr(maxKBLength - 5, ' ')).append("Size(KB) |").append("\n").append("|:").append(this.buildStr(maxNameLength, '-')).append("-").append("|:").append(this.buildStr(maxGroupIdLength, '-')).append("-").append("|:-------------------:").append("|-").append(this.buildStr(maxBLength + 2, '-')).append(":").append("|-").append(this.buildStr(maxKBLength + 3, '-')).append(":|").append("\n");
        for (Artifact jarArtifact : jarArtifacts) {
            File jarFile = jarArtifact.getFile();
            long fileLength = jarFile.length();
            history.append("| ").append(jarFile.getName()).append(this.buildIndent(maxNameLength, jarFile.getName())).append(SEPARATOR).append(jarArtifact.getGroupId()).append(this.buildIndent(maxGroupIdLength, jarArtifact.getGroupId())).append(SEPARATOR).append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(IOUtils.getFileLastModified(jarFile))).append(SEPARATOR).append(this.buildIndent(maxBLength, fileLength)).append(fileLength).append(" B").append(SEPARATOR).append(this.buildIndent(maxKBLength, fileLength / 1024L)).append(fileLength / 1024L).append(" KB").append(" |").append("\n");
        }
        String string = history.toString().trim();
        File historyFile = new File(this.outputDirectory, libDirName + ".history.md");
        String historyTxt = IOUtils.getFileTxt(historyFile);
        if (historyTxt != null) {
            if (!this.getLibHistoryTableTxt(historyTxt).equals(this.getLibHistoryTableTxt(string))) {
                this.warn("'%s/' \u76ee\u5f55\u4e2d\u7684JAR\u6587\u4ef6\u5df2\u53d8\u66f4\uff0c\u8bf7\u68c0\u67e5 '%s/%s.history.md' \u6587\u4ef6\u4e2d\u5df2\u53d8\u66f4\u7684JAR\uff0c\u5e76\u52a1\u5fc5\u4e0e\u5e94\u7528\u4e00\u8d77\u66f4\u65b0\uff0c\u907f\u514d\u5e94\u7528\u8fd0\u884c\u5f02\u5e38\uff01(%s)", libDirName, this.outputDirectory.getName(), libDirName, new SimpleDateFormat("HH:mm:ss.SSS").format(new Date()));
                File historyFileBak = new File(this.outputDirectory, libDirName + ".history.md.bak");
                int i = 1;
                while (historyFileBak.exists()) {
                    historyFileBak.setWritable(true);
                    historyFileBak = new File(this.outputDirectory, libDirName + ".history.md(" + i + ").bak");
                    ++i;
                }
                historyFile.renameTo(historyFileBak);
                this.updateLibHistoryFileLastModified(historyFileBak, historyTxt);
                historyFile.setWritable(true);
                IOUtils.createFile(historyFile, string);
            }
        } else {
            IOUtils.createFile(historyFile, string);
        }
        historyFile.setReadOnly();
    }

    private boolean isCommonJar(Artifact artifact, Set<String> commonDependencyPatternSet) {
        for (String commonArtifactPattern : commonDependencyPatternSet) {
            if (!MatchUtils.match(commonArtifactPattern, artifact.getGroupId() + ":" + artifact.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private String buildIndent(int maxNameLength, String name) {
        int diff = maxNameLength - name.length();
        return this.buildStr(diff, ' ');
    }

    private String buildIndent(int maxSizeLength, long size) {
        int diff = maxSizeLength - String.valueOf(size).length();
        return this.buildStr(diff, ' ');
    }

    private String buildStr(int length, char c) {
        StringBuilder sb = new StringBuilder();
        while (length > 0) {
            --length;
            sb.append(c);
        }
        return sb.toString();
    }

    String getLibHistoryTableTxt(String libHistoryTxt) {
        libHistoryTxt = libHistoryTxt.replaceAll("[ \t\r]+", "").replaceAll("[:\\-]+(?=\\|)", "").replaceAll("\\|{5,}", "||||");
        return libHistoryTxt.substring(libHistoryTxt.indexOf("||||") + 5).trim();
    }

    @Nullable
    String readLibHistoryFileCreatedOn(String historyTxt) {
        int idx = historyTxt.indexOf("Created-On:");
        if (idx < 0) {
            return null;
        }
        if ((historyTxt = historyTxt.substring(idx + 11).trim()).length() < 23) {
            return null;
        }
        return historyTxt.substring(0, 23);
    }

    @Nullable
    Date readLibHistoryFileCreatedTime(String historyTxt) {
        String timeStr = this.readLibHistoryFileCreatedOn(historyTxt);
        if (timeStr == null) {
            return null;
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").parse(timeStr);
        }
        catch (ParseException ignore) {
            return null;
        }
    }

    void updateLibHistoryFileLastModified(File libHistoryFile, String libHistoryTxt) {
        Date historyFileCreatedTime = this.readLibHistoryFileCreatedTime(libHistoryTxt);
        if (historyFileCreatedTime != null) {
            libHistoryFile.setLastModified(historyFileCreatedTime.getTime());
        }
    }

    private void createStartupFile(String loaderPath) throws IOException {
        if (!this.needCreateStartupFile) {
            return;
        }
        this.emptyLine();
        String startupScript = this.replacePlaceholder(this.startupScript.replaceAll("\\s*\\{\\s*startupScriptAdditionalParameter\\s*\\}", ObjectUtils.isNotEmpty(this.startupScriptAdditionalParameter) ? this.startupScriptAdditionalParameter : "")).replaceAll("\\s*\\{\\s*loaderPath\\s*\\}", ObjectUtils.isNotEmpty(loaderPath) ? " -Dloader.path=\"" + loaderPath + "\" ^" : "").replaceAll("\\s*\\{\\s*activeProfile\\s*\\}", this.activeProfile).replaceAll("\\s*(\\^|\\<br\\s*\\/\\>|\\\\)(\\s|\\^|\\<br\\s*\\/\\>|\\\\)*", " ^\r\n     ").trim();
        File activeProfileFile = new File(this.outputDirectory + "/target/classes/application-" + this.activeProfile + ".yml");
        if (!activeProfileFile.exists() || !activeProfileFile.isFile()) {
            IOUtils.createFile(activeProfileFile, "# " + this.activeProfile + "\u73af\u5883" + "\r\n" + "\r\n");
        }
        this.createStartupFile("bat", "title \"" + this.project.getBuild().getFinalName() + "\"" + "\r\n" + "\r\n" + startupScript + "\r\n\r\ncmd\r\n");
        this.createStartupFile("sh", "#!/bin/sh\r\n\r\n" + startupScript.replace('^', '\\') + "\r\n");
    }

    private void createStartupFile(String fileSuffix, String startupScriptText) {
        File file = new File(this.outputDirectory.getPath() + "\\target\\startup." + fileSuffix);
        try {
            IOUtils.createFile(file, startupScriptText);
            this.info("Create startup file succeeded: %s, the startup script:\r\n===>\r\n%s\r\n<===\r\n", file.getName(), startupScriptText.trim());
        }
        catch (IOException e) {
            this.error("Create startup file failed: %s", file.getName(), e);
        }
    }
}

