/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.print;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="print-project", threadSafe=true)
public class PrintProjectMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="maven.print.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="true")
    private boolean printModel;
    @Parameter(defaultValue="true")
    private boolean printOriginalModel;
    @Parameter(property="maven.print.detail", defaultValue="false")
    private boolean printDetail;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Print-Project has been skipped.");
            return;
        }
        if (this.project == null) {
            this.getLog().info((CharSequence)"The project is null");
            return;
        }
        if (this.printModel) {
            this.printModelStr(this.project.getModel(), "model");
        }
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"=====================================================================================================================");
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)"");
        if (this.printOriginalModel) {
            this.printModelStr(this.project.getOriginalModel(), "originalModel");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printModelStr(Model m, String modelName) {
        this.printLine();
        try {
            List dependencies;
            if (m == null) {
                this.getLog().info((CharSequence)("Print the project." + modelName + ": null"));
                return;
            }
            this.getLog().info((CharSequence)("Print the project." + modelName + ":"));
            Parent parent = m.getParent();
            if (parent != null) {
                this.getLog().info((CharSequence)String.format("parent: %s, %s", parent.getId(), parent.getRelativePath() != null && parent.getRelativePath().isEmpty() ? "<empty>" : parent.getRelativePath()));
            } else {
                this.getLog().info((CharSequence)"parent: null");
            }
            this.getLog().info((CharSequence)String.format("artifact: %s", m.getId()));
            if (m.getProperties() == null) {
                this.getLog().info((CharSequence)"properties: null");
            } else if (m.getProperties().isEmpty()) {
                this.getLog().info((CharSequence)"properties: 0");
            } else {
                Properties properties = m.getProperties();
                if (this.printDetail) {
                    this.printLine();
                }
                this.getLog().info((CharSequence)("properties: " + properties.size()));
                if (this.printDetail) {
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        this.getLog().info((CharSequence)("  " + (entry.getKey() == null ? "<null>" : entry.getKey()) + " = " + (entry.getValue() == null ? "<null>" : entry.getValue())));
                    }
                    this.printLine();
                }
            }
            if (m.getDependencyManagement() == null) {
                this.getLog().info((CharSequence)"dependencyManagement: null");
            } else if (m.getDependencyManagement().getDependencies() == null) {
                this.getLog().info((CharSequence)"dependencyManagement.dependencies: null");
            } else if (m.getDependencyManagement().getDependencies().isEmpty()) {
                this.getLog().info((CharSequence)"dependencyManagement.dependencies: 0");
            } else {
                dependencies = m.getDependencyManagement().getDependencies();
                if (this.printDetail) {
                    this.printLine();
                }
                this.getLog().info((CharSequence)("dependencyManagement: " + dependencies.size()));
                if (this.printDetail) {
                    this.printDependencies(dependencies);
                    this.printLine();
                }
            }
            if (m.getDependencies() == null) {
                this.getLog().info((CharSequence)"dependencies: null");
            } else {
                dependencies = m.getDependencies();
                if (this.printDetail) {
                    this.printLine();
                }
                this.getLog().info((CharSequence)("dependencies: " + dependencies.size()));
                if (this.printDetail) {
                    this.printDependencies(dependencies);
                    this.printLine();
                }
            }
            if (m.getBuild() == null) {
                this.getLog().info((CharSequence)"build: null");
                this.getLog().info((CharSequence)"build.pluginManagement: null");
                this.getLog().info((CharSequence)"build.plugins: null");
            } else {
                String config;
                String id;
                this.getLog().info((CharSequence)"build:");
                if (m.getBuild().getPluginManagement() == null) {
                    this.getLog().info((CharSequence)"build.pluginManagement: null");
                } else if (m.getBuild().getPluginManagement().getPlugins() == null) {
                    this.getLog().info((CharSequence)"build.pluginManagement.plugins: null");
                } else if (m.getBuild().getPluginManagement().getPlugins().isEmpty()) {
                    this.getLog().info((CharSequence)"build.pluginManagement.plugins: 0");
                } else {
                    if (this.printDetail) {
                        this.printLine();
                    }
                    this.getLog().info((CharSequence)("build.pluginManagement.plugins: " + m.getBuild().getPluginManagement().getPlugins().size()));
                    if (this.printDetail) {
                        for (Plugin plugin : m.getBuild().getPluginManagement().getPlugins()) {
                            id = plugin.getId();
                            config = plugin.getConfiguration() == null ? null : plugin.getConfiguration().toString().replace("\r", "").replace("\n", "\r\n" + this.createStr(' ', id.length() + 14));
                            this.getLog().info((CharSequence)("  " + id + " --- " + config));
                        }
                        this.printLine();
                    }
                }
                if (m.getBuild().getPlugins() == null) {
                    this.getLog().info((CharSequence)"build.plugins: null");
                } else if (m.getBuild().getPlugins().isEmpty()) {
                    this.getLog().info((CharSequence)"build.plugins: 0");
                } else {
                    if (this.printDetail) {
                        this.printLine();
                    }
                    this.getLog().info((CharSequence)("build.plugins: " + m.getBuild().getPlugins().size()));
                    if (this.printDetail) {
                        for (Plugin plugin : m.getBuild().getPlugins()) {
                            id = plugin.getId();
                            config = plugin.getConfiguration() == null ? null : plugin.getConfiguration().toString().replace("\r", "").replace("\n", "\r\n" + this.createStr(' ', id.length() + 14));
                            this.getLog().info((CharSequence)("  " + id + " --- " + config));
                        }
                        this.printLine();
                    }
                }
            }
        }
        finally {
            this.printLine();
        }
    }

    private String createStr(char c, int length) {
        StringBuilder sb = new StringBuilder(length);
        while (length > 0) {
            sb.append(c);
            --length;
        }
        return sb.toString();
    }

    private void printDependencies(List<Dependency> dependencies) {
        if (dependencies == null || dependencies.isEmpty()) {
            return;
        }
        for (Dependency dependency : dependencies) {
            this.getLog().info((CharSequence)("  " + dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getVersion() + ":" + dependency.getType() + (dependency.getClassifier() != null ? ":" + dependency.getClassifier() : "") + " : " + dependency.getScope() + " : " + dependency.getOptional() + " : " + dependency.getSystemPath() + " : " + (dependency.getExclusions() == null ? "null" : Integer.valueOf(dependency.getExclusions().size()))));
        }
    }

    private void printLine() {
        this.getLog().info((CharSequence)"-------------------------------------------");
    }
}

