/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.utils;

import icu.easyj.maven.plugin.mojo.utils.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;

public class ScopeFilter {
    private String includeScope;
    private String excludeScope;

    public ScopeFilter(String includeScope, String excludeScope) {
        this.includeScope = includeScope;
        this.excludeScope = excludeScope;
    }

    public boolean doFilter(Artifact artifact) {
        if (StringUtils.isNotEmpty(this.includeScope)) {
            if (!("compile".equals(this.includeScope) || "test".equals(this.includeScope) || "provided".equals(this.includeScope) || "runtime".equals(this.includeScope) || "system".equals(this.includeScope))) {
                throw new RuntimeException("Invalid Scope in includeScope: " + this.includeScope);
            }
            if ("provided".equals(this.includeScope) || "system".equals(this.includeScope)) {
                return this.includeSingleScope(artifact, this.includeScope);
            }
            ScopeArtifactFilter saf = new ScopeArtifactFilter(this.includeScope);
            return saf.include(artifact);
        }
        if (StringUtils.isNotEmpty(this.excludeScope)) {
            if (!("compile".equals(this.excludeScope) || "test".equals(this.excludeScope) || "provided".equals(this.excludeScope) || "runtime".equals(this.excludeScope) || "system".equals(this.excludeScope))) {
                throw new RuntimeException("Invalid Scope in excludeScope: " + this.excludeScope);
            }
            if ("test".equals(this.excludeScope)) {
                throw new RuntimeException(" Can't exclude Test scope, this will exclude everything.");
            }
            if (!"provided".equals(this.excludeScope) && !"system".equals(this.excludeScope)) {
                ScopeArtifactFilter saf = new ScopeArtifactFilter(this.excludeScope);
                return !saf.include(artifact);
            }
            return this.excludeSingleScope(artifact, this.excludeScope);
        }
        return false;
    }

    private boolean includeSingleScope(Artifact artifact, String scope) {
        return scope.equals(artifact.getScope());
    }

    private boolean excludeSingleScope(Artifact artifact, String scope) {
        return !this.includeSingleScope(artifact, scope);
    }
}

