/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.maven.plugin.mojo.simplify.simplifier;

import icu.easyj.maven.plugin.mojo.simplify.SimplifyMode;
import icu.easyj.maven.plugin.mojo.simplify.SimplifyPomMojoConfig;
import icu.easyj.maven.plugin.mojo.simplify.simplifier.AbstractPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplify.simplifier.jar.JarPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplify.simplifier.jar.ShadeJarPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplify.simplifier.jar.StarterPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplify.simplifier.mavenplugin.MavenPluginPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplify.simplifier.noop.NoopPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplify.simplifier.pom.BomPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplify.simplifier.pom.DependenciesPomSimplifier;
import icu.easyj.maven.plugin.mojo.simplify.simplifier.pom.PomSimplifier;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public abstract class PomSimplifierFactory {
    public static AbstractPomSimplifier create(MavenProject project, String modeStr, SimplifyPomMojoConfig config, Log log) {
        SimplifyMode mode = null;
        if ("auto".equalsIgnoreCase(modeStr)) {
            modeStr = null;
            if (PomSimplifierFactory.isBom(project)) {
                modeStr = "bom";
                log.info((CharSequence)("Set mode to '" + modeStr + "', because the artifactId \"" + project.getArtifactId() + "\".endsWith(\"-bom\")."));
            } else if (PomSimplifierFactory.isShade(project)) {
                modeStr = "shade";
                log.info((CharSequence)("Set mode to '" + modeStr + "', because the artifactId \"" + project.getArtifactId() + "\".endsWith(\"-all\")."));
            } else if (PomSimplifierFactory.isStarter(project)) {
                modeStr = "starter";
                if (project.getArtifactId().endsWith("-starter")) {
                    log.info((CharSequence)("Set mode to '" + modeStr + "', because the artifactId \"" + project.getArtifactId() + "\".endsWith(\"-starter\")."));
                } else {
                    log.info((CharSequence)("Set mode to '" + modeStr + "', because the artifactId \"" + project.getArtifactId() + "\".contains(\"-starter-\")."));
                }
            }
        }
        if (modeStr == null || modeStr.isEmpty()) {
            modeStr = project.getPackaging();
        } else {
            switch (modeStr.toLowerCase().replace('_', '-')) {
                case "pom": 
                case "jar": 
                case "war": 
                case "maven-plugin": {
                    if (modeStr.equalsIgnoreCase(project.getPackaging())) break;
                    PomSimplifierFactory.printWarnLog(project, modeStr, log);
                    break;
                }
                case "shade": {
                    if (PomSimplifierFactory.isJar(project)) break;
                    PomSimplifierFactory.printWarnLog(project, modeStr, log);
                    break;
                }
                case "dependencies": 
                case "bom": {
                    if (PomSimplifierFactory.isPom(project)) break;
                    PomSimplifierFactory.printWarnLog(project, modeStr, log);
                    break;
                }
                case "starter": {
                    if (PomSimplifierFactory.isJarOrPom(project)) break;
                    PomSimplifierFactory.printWarnLog(project, modeStr, log);
                    break;
                }
            }
        }
        try {
            mode = SimplifyMode.getByModeStr(modeStr);
        }
        catch (Exception e) {
            log.warn((CharSequence)("Get the mode by string '" + modeStr + "' failed: " + e));
        }
        if (mode == null) {
            mode = SimplifyMode.NOOP;
        }
        log.info((CharSequence)("The simplify mode is: " + (Object)((Object)mode)));
        config.setMode(mode);
        return PomSimplifierFactory.createInternal(project, config, log);
    }

    private static void printWarnLog(MavenProject project, String modeStr, Log log) {
        log.warn((CharSequence)("The mode '" + modeStr + "' can't used for packaging '" + project.getPackaging() + "'."));
    }

    private static AbstractPomSimplifier createInternal(MavenProject project, SimplifyPomMojoConfig config, Log log) {
        switch (config.getMode()) {
            case JAR: 
            case WAR: {
                return new JarPomSimplifier(project, config, log);
            }
            case STARTER: {
                return new StarterPomSimplifier(project, config, log);
            }
            case SHADE: {
                return new ShadeJarPomSimplifier(project, config, log);
            }
            case MAVEN_PLUGIN: {
                return new MavenPluginPomSimplifier(project, config, log);
            }
            case POM: {
                return new PomSimplifier(project, config, log);
            }
            case DEPENDENCIES: {
                return new DependenciesPomSimplifier(project, config, log);
            }
            case BOM: {
                return new BomPomSimplifier(project, config, log);
            }
        }
        return new NoopPomSimplifier(project, config, log);
    }

    private static boolean isJar(MavenProject project) {
        return "jar".equalsIgnoreCase(project.getPackaging());
    }

    private static boolean isPom(MavenProject project) {
        return "pom".equalsIgnoreCase(project.getPackaging());
    }

    private static boolean isJarOrPom(MavenProject project) {
        return PomSimplifierFactory.isJar(project) || PomSimplifierFactory.isPom(project);
    }

    private static boolean isBom(MavenProject project) {
        return PomSimplifierFactory.isPom(project) && project.getArtifactId().endsWith("-bom");
    }

    private static boolean isStarter(MavenProject project) {
        return PomSimplifierFactory.isJarOrPom(project) && (project.getArtifactId().endsWith("-starter") || project.getArtifactId().contains("-starter-"));
    }

    private static boolean isShade(MavenProject project) {
        return PomSimplifierFactory.isJar(project) && project.getArtifactId().endsWith("-all");
    }
}

