/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.middleware.dwz.server.core.service.impls;

import icu.easyj.core.exception.NotSupportedException;
import icu.easyj.core.sequence.ISequenceService;
import icu.easyj.middleware.dwz.server.core.service.IDwzCorrectErrorDataService;
import icu.easyj.middleware.dwz.server.core.store.IDwzLogStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDwzCorrectErrorDataServiceImpl
implements IDwzCorrectErrorDataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDwzCorrectErrorDataServiceImpl.class);
    private final IDwzLogStore dwzLogStore;
    private final ISequenceService sequenceService;

    public DefaultDwzCorrectErrorDataServiceImpl(IDwzLogStore dwzLogStore, ISequenceService sequenceService) {
        this.dwzLogStore = dwzLogStore;
        this.sequenceService = sequenceService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int correctSequence() {
        try {
            Long maxId;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("==>");
                LOGGER.info("\u5f00\u59cb\u7ea0\u6b63\u5e8f\u5217\u503c\uff0c\u5f53\u524d\u5e8f\u5217\u670d\u52a1\uff1a{}\uff0c\u5bf9\u5e94\u7684\u5e8f\u5217\u540d\uff1a{}\u3002", (Object)this.sequenceService.getClass().getSimpleName(), (Object)"SEQ_DWZ_LOG_ID");
            }
            long currVal = this.seqCurrValOrNextVal();
            try {
                maxId = this.dwzLogStore.getMaxId();
            }
            catch (NotSupportedException e) {
                LOGGER.warn("\u5f53\u524d\u77ed\u94fe\u63a5\u8bb0\u5f55\u5b58\u53d6\u670d\u52a1\u4e0d\u652f\u6301\u83b7\u53d6\u6700\u5927ID\uff0c\u65e0\u6cd5\u786e\u8ba4\u5f53\u524d\u5e8f\u5217\u503c\u662f\u5426\u6b63\u5e38\u3002", (Throwable)e);
                int n = -1;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("<==");
                }
                return n;
            }
            if (maxId == null) {
                maxId = 0L;
            }
            if (currVal < maxId) {
                int n = this.initSeqVal(currVal, maxId);
                return n;
            }
            LOGGER.info("\u76ee\u524d\u65e0\u9700\u7ea0\u6b63\u5e8f\u5217\u503c\uff01\u5f53\u524d\u5e8f\u5217\u503c\uff1a{}\uff0c\u5f53\u524d\u6700\u5927ID\u503c\uff1a{}\uff0c\u8be5\u5e8f\u5217\u670d\u52a1\u4e0d\u4f1a\u751f\u6210\u51fa\u5df2\u5b58\u5728\u7684ID\u3002", (Object)currVal, maxId == 0L ? "\u65e0\u6570\u636e" : maxId);
            int n = 0;
            return n;
        }
        finally {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("<==");
            }
        }
    }

    private long seqCurrValOrNextVal() {
        try {
            return this.sequenceService.currVal("SEQ_DWZ_LOG_ID");
        }
        catch (NotSupportedException e) {
            return this.sequenceService.nextVal("SEQ_DWZ_LOG_ID");
        }
    }

    private int initSeqVal(long currVal, long maxId) {
        try {
            this.sequenceService.setVal("SEQ_DWZ_LOG_ID", maxId);
            LOGGER.warn("\u5e8f\u5217[{}]\u7684\u5f53\u524d\u503c [{}] \u5c0f\u4e8e\u77ed\u94fe\u63a5\u8bb0\u5f55\u6700\u5927ID\u503c [{}]\uff0c\u73b0\u5df2\u521d\u59cb\u5316\u5e8f\u5217\u503c\u4e3a [{}]\u3002\u907f\u514d\u751f\u6210\u5df2\u5b58\u5728\u7684ID\uff0c\u5bfc\u81f4\u521b\u5efa\u77ed\u94fe\u63a5\u8bb0\u5f55\u5931\u8d25\u3002", new Object[]{"SEQ_DWZ_LOG_ID", currVal, maxId, maxId});
            return 1;
        }
        catch (NotSupportedException e) {
            if (maxId - currVal < 1000L) {
                return this.correctSequenceValue(currVal, maxId);
            }
            LOGGER.error("\u5e8f\u5217[{}]\u7684\u5f53\u524d\u503c\u592a\u5c0f [{}]\uff0c\u65e0\u6cd5\u5feb\u901f\u7ea0\u6b63\u5230\u77ed\u94fe\u63a5\u8bb0\u5f55\u6700\u5927ID\u503c [{}]\uff0c\u8bf7\u5c3d\u5feb\u624b\u52a8\u7ea0\u6b63!", new Object[]{"SEQ_DWZ_LOG_ID", currVal, maxId});
            return -1;
        }
    }

    private int correctSequenceValue(long currVal, long maxId) {
        LOGGER.warn("\u5e8f\u5217[{}]\u7684\u5f53\u524d\u503c [{}] \u5c0f\u4e8e\u77ed\u94fe\u63a5\u8bb0\u5f55\u6700\u5927ID\u503c [{}]\uff0c\u4f46\u5f53\u524d\u5e8f\u5217\u670d\u52a1\u4e0d\u652f\u6301 `setVal`\uff0c\u73b0\u6b63\u5728\u8fdb\u884c\u5e8f\u5217\u503c\u7d2f\u52a0\u64cd\u4f5c\uff0c\u76f4\u5230\u5e8f\u5217\u503c\u8fbe\u5230\u6700\u5927ID\u503c\u4e3a\u6b62...", new Object[]{"SEQ_DWZ_LOG_ID", currVal, maxId});
        long currVal0 = this.sequenceService.nextVal("SEQ_DWZ_LOG_ID");
        if (currVal0 < currVal) {
            LOGGER.warn("\u5e8f\u5217[{}]\u4e3a\u9012\u51cf\u5e8f\u5217\uff0c\u6682\u4e0d\u652f\u6301\u7ea0\u6b63\u9012\u51cf\u5e8f\u5217\u7684\u503c\uff01", (Object)"SEQ_DWZ_LOG_ID");
            return -1;
        }
        while (currVal0 < maxId) {
            currVal0 = this.sequenceService.nextVal("SEQ_DWZ_LOG_ID");
        }
        LOGGER.warn("\u5e8f\u5217[{}]\u7684\u5f53\u524d\u503c\u5df2\u8fbe\u5230 [{}]\uff0c\u670d\u52a1\u5df2\u7ecf\u53ef\u4ee5\u7ee7\u7eed\u670d\u52a1\u53ef\u7ee7\u7eed\u8fd0\u884c\u4e86\uff01", (Object)"SEQ_DWZ_LOG_ID", (Object)currVal);
        return 1;
    }
}

