/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.middleware.dwz.server.core.task;

import icu.easyj.middleware.dwz.server.core.config.DwzServerTaskConfig;
import icu.easyj.middleware.dwz.server.core.domain.enums.OvertimeHandleStrategy;
import icu.easyj.middleware.dwz.server.core.store.IDwzLogStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;

public class EasyjDwzServerTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(EasyjDwzServerTask.class);
    private final IDwzLogStore dwzLogStore;
    private final DwzServerTaskConfig dwzServerTaskConfig;

    public EasyjDwzServerTask(IDwzLogStore dwzLogStore, DwzServerTaskConfig dwzServerTaskConfig) {
        this.dwzLogStore = dwzLogStore;
        this.dwzServerTaskConfig = dwzServerTaskConfig;
    }

    @Scheduled(fixedDelay=600000L, initialDelay=5000L)
    public void handleOvertimeDwzLog() {
        if (this.dwzServerTaskConfig.getOvertimeHandleStrategy() == OvertimeHandleStrategy.DELETE) {
            int count = this.dwzLogStore.deleteOvertime();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u6b64\u6b21\u5220\u9664\u7684\u8d85\u65f6\u77ed\u94fe\u63a5\u8bb0\u5f55\u6570\u636e\u6709 {} \u6761", (Object)count);
            }
        } else {
            int count = this.dwzLogStore.updateOvertime();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u6b64\u6b21\u66f4\u65b0\u7684\u8d85\u65f6\u77ed\u94fe\u63a5\u8bb0\u5f55\u6570\u636e\u6709 {} \u6761", (Object)count);
            }
        }
    }
}

