/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.middleware.dwz.server.core.controller;

import icu.easyj.config.ServerConfigs;
import icu.easyj.core.util.StringUtils;
import icu.easyj.middleware.dwz.domain.EasyjDwzRequest;
import icu.easyj.middleware.dwz.domain.EasyjDwzResponse;
import icu.easyj.middleware.dwz.server.core.domain.entity.DwzLogEntity;
import icu.easyj.middleware.dwz.server.core.service.IDwzServerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1"})
public class DwzRestController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DwzRestController.class);
    private final IDwzServerService dwzServerService;

    public DwzRestController(IDwzServerService dwzServerService) {
        this.dwzServerService = dwzServerService;
    }

    @PostMapping(value={"/create-short-url"})
    public EasyjDwzResponse createShortUrl(@RequestBody EasyjDwzRequest param) {
        Assert.notNull((Object)param.getLongUrl(), (String)"\u957f\u94fe\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
        DwzLogEntity dwzLog = this.dwzServerService.createShortUrlCode(param.getLongUrl(), param.getTermOfValidity());
        String shortUrl = ServerConfigs.getDomain() + "/" + dwzLog.getShortUrlCode();
        return new EasyjDwzResponse(shortUrl, dwzLog.getCreateTime(), dwzLog.getTermOfValidity());
    }

    @Nullable
    @GetMapping(value={"/get-long-url"})
    public String getLongUrl(@RequestParam String shortUrl) {
        String shortUrlCode;
        if (shortUrl.startsWith(ServerConfigs.getDomain() + "/")) {
            shortUrlCode = shortUrl.substring(ServerConfigs.getDomain().length() + 1);
        } else {
            int idx = shortUrl.lastIndexOf(47);
            if (idx < shortUrl.length() - 1) {
                LOGGER.warn("\u77ed\u57df\u540d\u53c2\u6570\u53ef\u80fd\u4e0d\u662f\u5f53\u524d\u670d\u52a1\u751f\u6210\u7684\uff0cshortUrl = {}", (Object)shortUrl);
                shortUrlCode = shortUrl.substring(idx);
            } else {
                LOGGER.warn("\u975e\u6cd5\u7684\u77ed\u94fe\u63a5\uff0cshortUrl = {}", (Object)shortUrl);
                throw new IllegalArgumentException("\u975e\u6cd5\u7684\u77ed\u94fe\u63a5");
            }
        }
        if (StringUtils.isEmpty((CharSequence)shortUrl)) {
            LOGGER.warn("\u77ed\u94fe\u63a5\u4e2d\u7684\u77ed\u94fe\u63a5\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0cshortUrl = {}", (Object)shortUrl);
            throw new IllegalArgumentException("\u77ed\u94fe\u63a5\u4e2d\u7684\u77ed\u94fe\u63a5\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dwzServerService.getLongUrlByShortUrlCode(shortUrlCode);
    }
}

