/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.middleware.dwz.server.core.service.impls;

import icu.easyj.core.util.DateUtils;
import icu.easyj.middleware.dwz.server.core.domain.entity.DwzLogEntity;
import icu.easyj.middleware.dwz.server.core.domain.enums.DwzLogStatus;
import icu.easyj.middleware.dwz.server.core.service.IDwzServerService;
import icu.easyj.middleware.dwz.server.core.store.IDwzLogStore;
import icu.easyj.web.util.HttpUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.transaction.annotation.Transactional;

public class DefaultDwzServerServiceImpl
implements IDwzServerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDwzServerServiceImpl.class);
    private final IDwzLogStore logStore;

    public DefaultDwzServerServiceImpl(IDwzLogStore logStore) {
        this.logStore = logStore;
    }

    @Override
    @NonNull
    @Transactional
    public DwzLogEntity createShortUrlCode(@NonNull String longUrl, @Nullable Date termOfValidity) {
        if (!HttpUtils.isHttpOrHttps((String)longUrl)) {
            LOGGER.warn("\u957f\u94fe\u63a5\u4e0d\u662f\u6709\u6548\u7684http(s)\u5730\u5740\uff0clongUrl = {}", (Object)longUrl);
            throw new IllegalArgumentException("\u957f\u94fe\u63a5\u4e0d\u662f\u6709\u6548\u7684http(s)\u5730\u5740\uff1a" + longUrl);
        }
        if (termOfValidity != null && termOfValidity.getTime() <= System.currentTimeMillis()) {
            String termOfValidityStr = DateUtils.toString((Date)termOfValidity);
            LOGGER.warn("termOfValidity\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4, termOfValidity = {}\uff0clongUrl = {}", (Object)termOfValidityStr, (Object)longUrl);
            throw new IllegalArgumentException("termOfValidity\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e\u5f53\u524d\u65f6\u95f4\uff1a" + termOfValidityStr);
        }
        DwzLogEntity dwzLog = this.logStore.getByLongUrlForUpdate(longUrl);
        if (dwzLog != null) {
            boolean needUpdate = false;
            if (dwzLog.isNotStatus(DwzLogStatus.EFFECTIVE)) {
                dwzLog.setStatus(DwzLogStatus.EFFECTIVE);
                needUpdate = true;
            }
            if (dwzLog.getTermOfValidity() != null && (termOfValidity == null || dwzLog.getTermOfValidity().compareTo(termOfValidity) < 0)) {
                dwzLog.setTermOfValidity(null);
                needUpdate = true;
            }
            if (needUpdate) {
                this.logStore.update(dwzLog);
            }
            return dwzLog;
        }
        return this.logStore.save(longUrl, termOfValidity);
    }

    @Override
    @Nullable
    public String getLongUrlByShortUrlCode(@NonNull String shortUrlCode) {
        return this.logStore.getLongUrlByShortUrlCode(shortUrlCode);
    }
}

