/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.middleware.dwz.server.core.controller;

import icu.easyj.core.util.StringUtils;
import icu.easyj.middleware.dwz.server.core.service.IDwzServerService;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DwzRedirectController {
    private final IDwzServerService dwzServerService;

    public DwzRedirectController(IDwzServerService dwzServerService) {
        this.dwzServerService = dwzServerService;
    }

    @GetMapping(value={"/{shortUrlCode}"})
    public void redirect(@PathVariable String shortUrlCode, HttpServletResponse response) throws IOException {
        if (StringUtils.isBlank((CharSequence)shortUrlCode)) {
            throw new IllegalArgumentException("\u77ed\u94fe\u63a5\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String longUrl = this.dwzServerService.getLongUrlByShortUrlCode(shortUrlCode.trim());
        if (StringUtils.isBlank((CharSequence)longUrl)) {
            throw new IllegalArgumentException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u957f\u94fe\u63a5");
        }
        response.sendRedirect(longUrl.trim());
    }

    @GetMapping(value={"/test/long-url-page"})
    @ResponseBody
    public String test() {
        return "\u8fd9\u662f\u4e00\u4e2a\u957f\u94fe\u63a5\u7684\u9875\u9762";
    }
}

